/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.plugin;

import com.stratio.mojo.unix.core.AssemblyOperation;
import com.stratio.mojo.unix.core.CopyDirectoryOperation;
import com.stratio.mojo.unix.io.fs.Fs;
import com.stratio.mojo.unix.maven.plugin.AssemblyOp;
import com.stratio.mojo.unix.maven.plugin.MojoFileAttributes;
import com.stratio.mojo.unix.util.RelativePath;
import fj.P;
import fj.data.List;
import fj.data.Option;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileSetOp
extends AssemblyOp {
    private RelativePath to = RelativePath.BASE;
    private List<String> includes = List.nil();
    private List<String> excludes = List.nil();
    private String pattern;
    private String replacement;
    private MojoFileAttributes fileAttributes = new MojoFileAttributes();
    private MojoFileAttributes directoryAttributes = new MojoFileAttributes();

    public AbstractFileSetOp(String operationType) {
        super(operationType);
    }

    public void setTo(String to) {
        this.to = RelativePath.relativePath((String)to);
    }

    public void setIncludes(String[] includes) {
        this.includes = List.list((Object[])includes);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = List.list((Object[])excludes);
    }

    public void setPattern(String pattern) {
        this.pattern = AbstractFileSetOp.nullIfEmpty(pattern);
    }

    public void setReplacement(String replacement) {
        this.replacement = AbstractFileSetOp.nullIfEmpty(replacement);
    }

    public void setFileAttributes(MojoFileAttributes fileAttributes) {
        this.fileAttributes = fileAttributes;
    }

    public void setDirectoryAttributes(MojoFileAttributes directoryAttributes) {
        this.directoryAttributes = directoryAttributes;
    }

    protected AssemblyOperation createCopyArchiveOperation(Fs<?> archive, AssemblyOp.CreateOperationContext context) throws MojoFailureException {
        Option pattern = Option.none();
        if (this.pattern != null) {
            if (this.replacement == null) {
                throw new MojoFailureException("A replacement expression has to be set if a pattern is given.");
            }
            pattern = Option.some((Object)P.p((Object)this.pattern, (Object)this.replacement));
        }
        return new CopyDirectoryOperation(archive, this.to, this.includes, this.excludes, pattern, context.defaultFileAttributes.useAsDefaultsFor(this.fileAttributes.create()), context.defaultDirectoryAttributes.useAsDefaultsFor(this.directoryAttributes.create()));
    }
}

