/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.plugin;

import com.stratio.mojo.unix.FileAttributes;
import com.stratio.mojo.unix.core.AssemblyOperation;
import com.stratio.mojo.unix.io.fs.LocalFs;
import com.stratio.mojo.unix.maven.plugin.MavenProjectWrapper;
import com.stratio.mojo.unix.maven.plugin.UnknownArtifactException;
import com.stratio.mojo.unix.util.RelativePath;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public abstract class AssemblyOp {
    protected final String operationType;

    protected AssemblyOp(String operationType) {
        this.operationType = operationType;
    }

    public abstract AssemblyOperation createOperation(CreateOperationContext var1) throws MojoFailureException, UnknownArtifactException, IOException;

    protected static String nullIfEmpty(String artifact) {
        return StringUtils.clean((String)artifact).length() == 0 ? null : artifact;
    }

    protected void validateIsSet(Object valueA, String fieldA) throws MojoFailureException {
        if (valueA == null) {
            throw new MojoFailureException("Field '" + fieldA + "' has to be specified on a " + this.operationType + " operation.");
        }
    }

    protected void validateEitherIsSet(Object valueA, Object valueB, String fieldA, String fieldB) throws MojoFailureException {
        if (valueA != null && valueB != null) {
            throw new MojoFailureException("Only one of '" + fieldA + "' and '" + fieldB + "' can be specified on a " + this.operationType + " operation.");
        }
        if (valueA == null && valueB == null) {
            throw new MojoFailureException("One of '" + fieldA + "' and '" + fieldB + "' has to be specified on a " + this.operationType + " operation.");
        }
    }

    protected RelativePath validateAndResolveOutputFile(File artifactFile, RelativePath toDir, RelativePath toFile) throws MojoFailureException {
        if (toFile != null) {
            if (toDir != null) {
                throw new MojoFailureException("Can't specify both 'toDir' and 'toFile' on a " + this.operationType + " operation.");
            }
            return toFile;
        }
        if (toDir == null) {
            toDir = RelativePath.BASE;
        }
        return toDir.add(artifactFile.getName());
    }

    protected File validateFileIsReadableFile(File file, String fieldName) throws MojoFailureException {
        if (!file.isFile()) {
            throw new MojoFailureException("The path specified in field '" + fieldName + "' on an " + this.operationType + " operation is not a file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new MojoFailureException("The path specified in field '" + fieldName + " on an " + this.operationType + " operation is not readable " + file.getAbsolutePath());
        }
        return file;
    }

    protected File validateFileIsDirectory(File file, String fieldName) throws MojoFailureException {
        if (!file.isDirectory()) {
            throw new MojoFailureException("The path specified in field '" + fieldName + "' on an " + this.operationType + " is not a directory: " + file.getAbsolutePath());
        }
        return file;
    }

    public static class CreateOperationContext {
        public final LocalFs basedir;
        public final FileAttributes defaultFileAttributes;
        public final FileAttributes defaultDirectoryAttributes;
        public final MavenProjectWrapper project;

        public CreateOperationContext(LocalFs basedir, FileAttributes defaultFileAttributes, FileAttributes defaultDirectoryAttributes, MavenProjectWrapper project) {
            this.basedir = basedir;
            this.defaultFileAttributes = defaultFileAttributes;
            this.defaultDirectoryAttributes = defaultDirectoryAttributes;
            this.project = project;
        }
    }
}

