/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.plugin;

import com.stratio.mojo.unix.core.AssemblyOperation;
import com.stratio.mojo.unix.core.CopyFileOperation;
import com.stratio.mojo.unix.io.fs.Fs;
import com.stratio.mojo.unix.io.fs.LocalFs;
import com.stratio.mojo.unix.maven.plugin.AssemblyOp;
import com.stratio.mojo.unix.maven.plugin.MojoFileAttributes;
import com.stratio.mojo.unix.maven.plugin.UnknownArtifactException;
import com.stratio.mojo.unix.util.RelativePath;
import java.io.File;
import org.apache.maven.plugin.MojoFailureException;

public class CopyArtifact
extends AssemblyOp {
    private String artifact;
    private RelativePath toFile;
    private RelativePath toDir;
    private MojoFileAttributes attributes = new MojoFileAttributes();

    public CopyArtifact() {
        super("copy-artifact");
    }

    public void setArtifact(String artifact) {
        this.artifact = CopyArtifact.nullIfEmpty(artifact);
    }

    public void setToFile(String toFile) {
        this.toFile = RelativePath.relativePath((String)toFile);
    }

    public void setToDir(String toDir) {
        this.toDir = RelativePath.relativePath((String)toDir);
    }

    public void setAttributes(MojoFileAttributes attributes) {
        this.attributes = attributes;
    }

    public AssemblyOperation createOperation(AssemblyOp.CreateOperationContext context) throws MojoFailureException, UnknownArtifactException {
        File artifactFile = context.project.artifactMap.validateArtifact(this.artifact);
        RelativePath toFile = this.validateAndResolveOutputFile(artifactFile, this.toDir, this.toFile);
        return new CopyFileOperation(context.defaultFileAttributes.useAsDefaultsFor(this.attributes.create()), (Fs)new LocalFs(artifactFile), toFile);
    }
}

