/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.plugin;

import com.stratio.mojo.unix.util.SystemCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;

public class DpkgScanPackagesMojo
extends AbstractMojo {
    private File root;
    private String pathPrefix;
    private String overrideFile;
    private boolean multiversion;
    protected boolean debug;
    protected File outputFile;
    private String localRepository;
    private File basedir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.root == null) {
            this.root = new File(this.localRepository);
        }
        if (!this.outputFile.isAbsolute()) {
            this.outputFile = new File(this.basedir, this.outputFile.getPath());
        }
        if (!this.outputFile.getParentFile().isDirectory() && !this.outputFile.getParentFile().mkdirs()) {
            throw new MojoFailureException("Could not create parent directories for package file: " + this.outputFile.getAbsolutePath());
        }
        OutputStream output = null;
        try {
            output = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            new SystemCommand().dumpCommandIf(this.debug).withStdoutConsumer(output).withStderrConsumer((OutputStream)System.out).setCommand("dpkg-scanpackages").setBasedir(this.root).addArgumentIf(this.multiversion, "-m").addArgument(".").addArgument(this.overrideFile).addArgumentIfNotEmpty(this.pathPrefix).execute().assertSuccess();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Could not run dpkg-scanpackages.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)output);
    }
}

