/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.plugin;

import com.stratio.mojo.unix.UnixFsObject;
import com.stratio.mojo.unix.core.AssemblyOperation;
import com.stratio.mojo.unix.core.FilterFilesOperation;
import com.stratio.mojo.unix.io.LineEnding;
import com.stratio.mojo.unix.maven.plugin.AssemblyOp;
import com.stratio.mojo.unix.maven.plugin.Regex;
import com.stratio.mojo.unix.maven.plugin.UnknownArtifactException;
import fj.data.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFiles
extends AssemblyOp {
    private List<String> includes = List.nil();
    private List<String> excludes = List.nil();
    private String lineEnding = LineEnding.keep.name();
    private Regex[] regexes = new Regex[0];

    public FilterFiles() {
        super("filter-files");
    }

    public void setIncludes(String[] includes) {
        this.includes = List.list((Object[])includes);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = List.list((Object[])excludes);
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    public void setRegexes(Regex[] regexes) {
        this.regexes = regexes;
    }

    @Override
    public AssemblyOperation createOperation(AssemblyOp.CreateOperationContext context) throws MojoFailureException, UnknownArtifactException {
        LineEnding lineEnding1 = this.valueOf();
        List<UnixFsObject.Replacer> replacers = this.regexes.length > 0 ? this.regexReplacers() : this.propertyReplacers(context.project.properties);
        return new FilterFilesOperation(this.includes, this.excludes, replacers, lineEnding1);
    }

    private LineEnding valueOf() throws MojoFailureException {
        try {
            return LineEnding.valueOf((String)this.lineEnding);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Unknown line ending: " + this.lineEnding);
        }
    }

    private List<UnixFsObject.Replacer> propertyReplacers(Map<String, String> properties) throws MojoFailureException {
        List replacers = List.nil();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = "${" + entry.getKey() + "}";
            try {
                String pattern = Pattern.quote(key);
                replacers = replacers.cons((Object)new UnixFsObject.Replacer(pattern, entry.getValue()));
            }
            catch (PatternSyntaxException e) {
                throw new MojoFailureException("Illegal pattern: " + key);
            }
        }
        return replacers;
    }

    private List<UnixFsObject.Replacer> regexReplacers() {
        List replacers = List.nil();
        UnixFsObject.Replacer[] rs = new UnixFsObject.Replacer[this.regexes.length];
        for (int i = this.regexes.length - 1; i >= 0; --i) {
            replacers = replacers.cons((Object)this.regexes[i].toReplacer());
        }
        return replacers.reverse();
    }
}

