/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.plugin;

import com.stratio.mojo.unix.maven.plugin.UnknownArtifactException;
import com.stratio.mojo.unix.util.Validate;
import fj.data.Option;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectWrapper {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final Artifact artifact;
    public final String name;
    public final Option<String> description;
    public final File basedir;
    public final File buildDirectory;
    public final LocalDateTime timestamp;
    public final Set<Artifact> artifacts;
    public final List<License> licenses;
    public final ArtifactMap artifactMap;
    public final SortedMap<String, String> properties;
    public final String outputFileName;

    public MavenProjectWrapper(String groupId, String artifactId, String outputFileName, String version, Artifact artifact, String name, String description, File basedir, File buildDirectory, LocalDateTime timestamp, Set<Artifact> artifacts, List<License> licenses, ArtifactMap artifactMap, SortedMap<String, String> properties) {
        Validate.validateNotNull((Object[])new Object[]{groupId, artifactId, version, name});
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifact = artifact;
        this.name = name;
        this.description = Option.fromNull((Object)description);
        this.basedir = basedir;
        this.buildDirectory = buildDirectory;
        this.timestamp = timestamp;
        this.artifacts = artifacts;
        this.licenses = licenses;
        this.artifactMap = artifactMap;
        this.properties = properties;
        this.outputFileName = outputFileName == null ? artifactId : outputFileName;
    }

    public static MavenProjectWrapper mavenProjectWrapper(MavenProject project, MavenSession session) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.putAll(MavenProjectWrapper.toMap(session.getSystemProperties()));
        properties.putAll(MavenProjectWrapper.toMap(session.getUserProperties()));
        properties.putAll(MavenProjectWrapper.toMap(project.getProperties()));
        properties.put("project.groupId", project.getGroupId());
        properties.put("project.artifactId", project.getArtifactId());
        properties.put("project.version", project.getVersion());
        if (project.getProperties().getProperty("outputFileName") != null) {
            properties.put("project.ouputFileName", project.getProperties().getProperty("outputFileName"));
        }
        return new MavenProjectWrapper(project.getGroupId(), project.getArtifactId(), project.getProperties().getProperty("outputFileName"), project.getVersion(), project.getArtifact(), project.getName(), project.getDescription(), project.getBasedir(), new File(project.getBuild().getDirectory()), new LocalDateTime(), project.getArtifacts(), project.getLicenses(), new ArtifactMap(project.getArtifacts()), Collections.unmodifiableSortedMap(properties));
    }

    private static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArtifactMap {
        private final Map<String, Artifact> artifacts = new HashMap<String, Artifact>();

        public ArtifactMap(Set<Artifact> artifacts) {
            for (Artifact artifact : artifacts) {
                this.artifacts.put(artifact.getDependencyConflictId(), artifact);
            }
        }

        public File validateArtifact(String artifact) throws UnknownArtifactException {
            Artifact a = this.artifacts.get(artifact);
            if (a != null) {
                return a.getFile();
            }
            a = this.artifacts.get(artifact + ":jar");
            if (a != null) {
                return a.getFile();
            }
            throw new UnknownArtifactException(artifact, this.artifacts);
        }
    }
}

