/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.rpm;

import com.stratio.mojo.unix.FileAttributes;
import com.stratio.mojo.unix.MissingSettingException;
import com.stratio.mojo.unix.PackageParameters;
import com.stratio.mojo.unix.PackageVersion;
import com.stratio.mojo.unix.UnixFsObject;
import com.stratio.mojo.unix.UnixPackage;
import com.stratio.mojo.unix.core.FsFileCollector;
import com.stratio.mojo.unix.io.fs.Fs;
import com.stratio.mojo.unix.io.fs.LocalFs;
import com.stratio.mojo.unix.rpm.Rpmbuild;
import com.stratio.mojo.unix.rpm.SpecFile;
import com.stratio.mojo.unix.util.RelativePath;
import com.stratio.mojo.unix.util.ScriptUtil;
import com.stratio.mojo.unix.util.line.LineProducer;
import com.stratio.mojo.unix.util.line.LineStreamUtil;
import fj.F;
import fj.P;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.plexus.util.FileUtils;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmUnixPackage
extends UnixPackage<RpmUnixPackage, RpmPreparedPackage> {
    private SpecFile specFile;
    private FsFileCollector fileCollector;
    private Option<String> rpmbuild;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("pre", "post", "preun", "postun");

    public RpmUnixPackage() {
        super("rpm");
    }

    public RpmUnixPackage parameters(PackageParameters parameters) {
        if (parameters.license.isNone()) {
            throw new MissingSettingException("The project has to specify a license.");
        }
        this.specFile = new SpecFile();
        this.specFile.name = parameters.id;
        this.specFile.summary = parameters.name;
        this.specFile.description = (String)parameters.description.orSome((Object)"");
        this.specFile.license = (String)parameters.license.some();
        this.specFile.buildArch = (String)parameters.architecture.orSome((Object)"noarch");
        P2<String, String> rpmVersion = RpmUnixPackage.getRpmVersion(parameters.version);
        this.specFile.version = (String)rpmVersion._1();
        this.specFile.release = (String)rpmVersion._2();
        SpecFile.excludedSysPaths.addAll(parameters.excludeDirs.toCollection());
        return this;
    }

    public RpmUnixPackage rpmParameters(String group, Option<String> rpmbuild, String requires) {
        if (requires != null) {
            this.specFile.requires = List.single((Object)requires);
        }
        this.specFile.group = group;
        this.rpmbuild = rpmbuild;
        return this;
    }

    public RpmUnixPackage debug(boolean debug) {
        this.specFile.dump = debug;
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes, LocalDateTime timestamp) throws IOException {
        this.specFile.beforeAssembly(UnixFsObject.directory((RelativePath)RelativePath.BASE, (LocalDateTime)new LocalDateTime(), (FileAttributes)defaultDirectoryAttributes));
        this.fileCollector = new FsFileCollector(this.workingDirectory.resolve(RelativePath.relativePath((String)"assembly")));
    }

    public void addDirectory(UnixFsObject.Directory directory) throws IOException {
        if (!SpecFile.excludedSysPaths.contains(directory.path.asAbsolutePath("/"))) {
            this.specFile.addDirectory(directory);
            this.fileCollector.addDirectory(directory);
        }
    }

    public void addFile(Fs<?> fromFile, UnixFsObject.RegularFile file) throws IOException {
        if (!SpecFile.excludedSysPaths.contains(file.path.asAbsolutePath("/"))) {
            this.specFile.addFile(file);
            this.fileCollector.addFile(fromFile, file);
        } else if ("/DEBIAN/conffiles".equals(file.path.asAbsolutePath("/"))) {
            BufferedReader reader = null;
            ArrayList<String> confFile = new ArrayList<String>();
            try {
                String line;
                reader = new BufferedReader(new FileReader(((LocalFs)fromFile).file));
                while ((line = reader.readLine()) != null) {
                    if ("".equals(line.trim())) continue;
                    confFile.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SpecFile.confFile = confFile;
        }
    }

    public void addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.specFile.addSymlink(symlink);
        this.fileCollector.addSymlink(symlink);
    }

    public void apply(F<UnixFsObject, Option<UnixFsObject>> f) {
        this.specFile.apply(f);
        this.fileCollector.apply(f);
    }

    public RpmPreparedPackage prepare(ScriptUtil.Strategy strategy) throws Exception {
        File rpms = new File(this.workingDirectory.file, "RPMS");
        File specsDir = new File(this.workingDirectory.file, "SPECS");
        File tmp = new File(this.workingDirectory.file, "tmp");
        File specFilePath = new File(specsDir, this.specFile.name + ".spec");
        FileUtils.forceMkdir((File)new File(this.workingDirectory.file, "BUILD"));
        FileUtils.forceMkdir((File)rpms);
        FileUtils.forceMkdir((File)new File(this.workingDirectory.file, "SOURCES"));
        FileUtils.forceMkdir((File)specsDir);
        FileUtils.forceMkdir((File)new File(this.workingDirectory.file, "SRPMS"));
        FileUtils.forceMkdir((File)tmp);
        this.fileCollector.collect();
        ScriptUtil.Result result = scriptUtil.createExecution(this.specFile.name, "rpm", this.getScripts(), this.workingDirectory.file, strategy).execute();
        this.specFile.includePre = result.preInstall;
        this.specFile.includePost = result.postInstall;
        this.specFile.includePreun = result.preRemove;
        this.specFile.includePostun = result.postRemove;
        this.specFile.buildRoot = this.fileCollector.root.file;
        LineStreamUtil.toFile((LineProducer)this.specFile, (File)specFilePath);
        return new RpmPreparedPackage(tmp, specFilePath);
    }

    public static P2<String, String> getRpmVersion(PackageVersion version) {
        String v = version.version;
        if (version.snapshot) {
            v = v + "-" + version.timestamp;
        }
        return P.p((Object)v.replace('-', '_'), (Object)"1");
    }

    public String getArchitecture() {
        return this.specFile.buildArch;
    }

    public String getOutputFileName() {
        return this.specFile.name;
    }

    public class RpmPreparedPackage
    extends UnixPackage.PreparedPackage {
        private final File tmp;
        private final File specFilePath;

        RpmPreparedPackage(File tmp, File specFilePath) {
            super((UnixPackage)RpmUnixPackage.this);
            this.tmp = tmp;
            this.specFilePath = specFilePath;
        }

        public void packageToFile(File packageFile) throws Exception {
            new Rpmbuild().setDebug(RpmUnixPackage.this.debug).setBuildroot(((RpmUnixPackage)RpmUnixPackage.this).specFile.buildRoot).define("_tmppath " + this.tmp.getAbsolutePath()).define("_topdir " + ((RpmUnixPackage)RpmUnixPackage.this).workingDirectory.file.getAbsolutePath()).define("_rpmdir " + packageFile.getParentFile().getAbsolutePath()).define("_rpmfilename " + packageFile.getName()).setSpecFile(this.specFilePath).setRpmbuild(RpmUnixPackage.this.rpmbuild).buildBinary();
        }
    }
}

