/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.sysvpkg;

import com.stratio.mojo.unix.FileAttributes;
import com.stratio.mojo.unix.PackageParameters;
import com.stratio.mojo.unix.PackageVersion;
import com.stratio.mojo.unix.UnixFsObject;
import com.stratio.mojo.unix.UnixPackage;
import com.stratio.mojo.unix.core.FsFileCollector;
import com.stratio.mojo.unix.io.IoEffect;
import com.stratio.mojo.unix.io.fs.Fs;
import com.stratio.mojo.unix.io.fs.LocalFs;
import com.stratio.mojo.unix.sysvpkg.Pkginfo;
import com.stratio.mojo.unix.sysvpkg.PkgmkCommand;
import com.stratio.mojo.unix.sysvpkg.PkgtransCommand;
import com.stratio.mojo.unix.sysvpkg.prototype.DirectoryEntry;
import com.stratio.mojo.unix.sysvpkg.prototype.PrototypeFile;
import com.stratio.mojo.unix.util.RelativePath;
import com.stratio.mojo.unix.util.ScriptUtil;
import com.stratio.mojo.unix.util.line.LineProducer;
import com.stratio.mojo.unix.util.line.LineStreamUtil;
import fj.F;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.codehaus.plexus.util.IOUtil;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkgUnixPackage
extends UnixPackage<PkgUnixPackage, PkgPreparedPackage> {
    private LocalFs prototype;
    private LocalFs pkginfoFile;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("preinstall", "postinstall", "preremove", "postremove").customScript("depend").customScript("checkinstall").customScript("compver").customScript("copyright").customScript("request").customScript("space");
    private PrototypeFile prototypeFile;
    private Pkginfo pkginfo;
    private List<IoEffect> operations = List.nil();
    private Option<String> classifier = Option.none();

    public PkgUnixPackage() {
        super("pkg");
    }

    public PkgUnixPackage parameters(PackageParameters parameters) {
        this.classifier = parameters.classifier;
        this.pkginfo = new Pkginfo((String)parameters.architecture.orSome((Object)"all"), "application", parameters.name, parameters.id, PkgUnixPackage.getPkgVersion(parameters.version)).desc(parameters.description).email(parameters.contactEmail).size(parameters.size).pstamp(Option.some((Object)parameters.version.timestamp)).outputFileName(parameters.outputFileName);
        return this;
    }

    public PkgUnixPackage debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes, LocalDateTime timestamp) throws IOException {
        this.prototype = this.workingDirectory.resolve(RelativePath.relativePath((String)"prototype"));
        this.pkginfoFile = this.workingDirectory.resolve(RelativePath.relativePath((String)"pkginfo"));
        UnixFsObject.Directory defaultDirectory = UnixFsObject.directory((RelativePath)RelativePath.BASE, (LocalDateTime)LocalDateTime.fromDateFields((Date)new Date(0L)), (FileAttributes)defaultDirectoryAttributes);
        DirectoryEntry directoryEntry = new DirectoryEntry(Option.none(), defaultDirectory);
        this.prototypeFile = new PrototypeFile(directoryEntry);
    }

    public PkgUnixPackage pkgParameters(List<String> classes, Option<String> category) {
        this.pkginfo = this.pkginfo.category((String)category.orSome((Object)this.pkginfo.category)).classes(classes);
        return this;
    }

    public PkgPreparedPackage prepare(ScriptUtil.Strategy strategy) throws Exception {
        RelativePath[] specialPaths;
        this.workingDirectory.mkdir();
        for (RelativePath specialPath : specialPaths = new RelativePath[]{RelativePath.BASE, RelativePath.relativePath((String)"/etc"), RelativePath.relativePath((String)"/etc/opt"), RelativePath.relativePath((String)"/opt"), RelativePath.relativePath((String)"/usr"), RelativePath.relativePath((String)"/var"), RelativePath.relativePath((String)"/var/opt")}) {
            if (!this.prototypeFile.hasPath(specialPath)) continue;
            this.prototypeFile.addDirectory(UnixFsObject.directory((RelativePath)specialPath, (LocalDateTime)new LocalDateTime(), (FileAttributes)FileAttributes.EMPTY));
        }
        ScriptUtil.Result result = scriptUtil.createExecution((String)this.classifier.orSome((Object)"default"), "pkg", this.getScripts(), this.workingDirectory.file, strategy).execute();
        LineStreamUtil.toFile((List)this.pkginfo.toList(), (File)this.pkginfoFile.file);
        this.prototypeFile.addIFileIf(this.pkginfoFile.file, "pkginfo");
        this.prototypeFile.addIFileIf(result.preInstall, "preinstall");
        this.prototypeFile.addIFileIf(result.postInstall, "postinstall");
        this.prototypeFile.addIFileIf(result.preRemove, "preremove");
        this.prototypeFile.addIFileIf(result.postRemove, "postremove");
        for (File file : result.customScripts) {
            this.prototypeFile.addIFileIf(file);
        }
        for (IoEffect operation : this.operations) {
            operation.run();
        }
        LineStreamUtil.toFile((LineProducer)this.prototypeFile, (File)this.prototype.file);
        return new PkgPreparedPackage();
    }

    public static String getPkgVersion(PackageVersion v) {
        String version = v.version;
        if (v.snapshot) {
            version = version + "-" + v.timestamp;
        }
        if (v.revision.isSome()) {
            version = version + "-" + (String)v.revision.some();
        }
        return version;
    }

    public void addDirectory(UnixFsObject.Directory directory) throws IOException {
        this.prototypeFile.addDirectory(directory);
    }

    public void addFile(Fs<?> fromFile, UnixFsObject.RegularFile file) throws IOException {
        this.prototypeFile.addFile(this.fromFile(fromFile, file), file);
    }

    public void addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.prototypeFile.addSymlink(symlink);
    }

    public void apply(F<UnixFsObject, Option<UnixFsObject>> f) {
        this.prototypeFile.apply(f);
    }

    public LocalFs fromFile(final Fs<?> fromFile, final UnixFsObject.RegularFile file) {
        if (fromFile instanceof LocalFs && !FsFileCollector.needsFiltering((UnixFsObject)file)) {
            return (LocalFs)fromFile;
        }
        final LocalFs tmpFile = this.workingDirectory.resolve(RelativePath.relativePath((String)"assembly").add(file.path));
        this.operations = this.operations.cons((Object)new IoEffect(){

            public void run() throws IOException {
                OutputStream outputStream = null;
                try {
                    P2 p2 = FsFileCollector.filtersAndLineEndingHandingInputStream((UnixFsObject)file, (InputStream)fromFile.inputStream());
                    tmpFile.parent().mkdir();
                    tmpFile.copyFrom(fromFile, (InputStream)p2._1());
                }
                finally {
                    IOUtil.close(outputStream);
                }
            }
        });
        return tmpFile;
    }

    public String getArchitecture() {
        return "";
    }

    public String getOutputFileName() {
        return "";
    }

    public class PkgPreparedPackage
    extends UnixPackage.PreparedPackage {
        public PkgPreparedPackage() {
            super((UnixPackage)PkgUnixPackage.this);
        }

        public void packageToFile(File packageFile) throws Exception {
            String pkg = PkgUnixPackage.this.pkginfo.getPkgName(((PkgUnixPackage)PkgUnixPackage.this).pkginfoFile.file);
            new PkgmkCommand().setDebug(PkgUnixPackage.this.debug).setOverwrite(true).setDevice(((PkgUnixPackage)PkgUnixPackage.this).workingDirectory.file).setPrototype(((PkgUnixPackage)PkgUnixPackage.this).prototype.file).execute();
            new PkgtransCommand().setDebug(PkgUnixPackage.this.debug).setAsDatastream(true).setOverwrite(true).execute(((PkgUnixPackage)PkgUnixPackage.this).workingDirectory.file, packageFile, pkg);
        }
    }
}

