/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.zip;

import com.stratio.mojo.unix.BasicPackageFileSystemObject;
import com.stratio.mojo.unix.FileAttributes;
import com.stratio.mojo.unix.PackageFileSystem;
import com.stratio.mojo.unix.PackageFileSystemObject;
import com.stratio.mojo.unix.PackageParameters;
import com.stratio.mojo.unix.UnixFileMode;
import com.stratio.mojo.unix.UnixFsObject;
import com.stratio.mojo.unix.UnixPackage;
import com.stratio.mojo.unix.core.FsFileCollector;
import com.stratio.mojo.unix.io.IoEffect;
import com.stratio.mojo.unix.io.fs.Fs;
import com.stratio.mojo.unix.java.BooleanF;
import com.stratio.mojo.unix.util.RelativePath;
import com.stratio.mojo.unix.util.ScriptUtil;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P2;
import fj.data.Option;
import fj.data.Stream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUnixPackage
extends UnixPackage<ZipUnixPackage, ZipPreparedPackage> {
    private PackageFileSystem<F2<UnixFsObject, ZipArchiveOutputStream, IoEffect>> fileSystem;
    private final Log log;

    public ZipUnixPackage(Log log) {
        super("zip");
        this.log = log;
    }

    public ZipUnixPackage parameters(PackageParameters parameters) {
        return this;
    }

    public void addDirectory(UnixFsObject.Directory directory) throws IOException {
        this.fileSystem = this.fileSystem.addDirectory(this.directory(directory));
    }

    public void addFile(Fs<?> fromFile, UnixFsObject.RegularFile file) throws IOException {
        this.fileSystem = this.fileSystem.addFile(this.file(fromFile, (UnixFsObject)file));
    }

    public void addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.log.warn((CharSequence)"Symlinks are not supported in ZIP files.");
    }

    public void apply(F<UnixFsObject, Option<UnixFsObject>> f) {
        this.fileSystem = this.fileSystem.apply(f);
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes, LocalDateTime timestamp) throws IOException {
        UnixFsObject.Directory rootDirectory = UnixFsObject.Directory.directory((RelativePath)RelativePath.BASE, (LocalDateTime)timestamp, (FileAttributes)FileAttributes.EMPTY);
        this.fileSystem = PackageFileSystem.create(this.directory(rootDirectory), this.directory(rootDirectory));
    }

    public ZipPreparedPackage prepare(ScriptUtil.Strategy strategy) throws Exception {
        return new ZipPreparedPackage();
    }

    public static <A> F2<RelativePath, PackageFileSystemObject<A>, Boolean> pathFilter() {
        return new F2<RelativePath, PackageFileSystemObject<A>, Boolean>(){

            public Boolean f(RelativePath path, PackageFileSystemObject object) {
                return object.getUnixFsObject().path.equals((Object)path);
            }
        };
    }

    private BasicPackageFileSystemObject<F2<UnixFsObject, ZipArchiveOutputStream, IoEffect>> directory(UnixFsObject.Directory directory) {
        F2<UnixFsObject, ZipArchiveOutputStream, IoEffect> f = new F2<UnixFsObject, ZipArchiveOutputStream, IoEffect>(){

            public IoEffect f(final UnixFsObject file, final ZipArchiveOutputStream zos) {
                return new IoEffect(){

                    public void run() throws IOException {
                        String path = file.path.isBase() ? "." : file.path.asAbsolutePath("./") + "/";
                        ZipArchiveEntry entry = new ZipArchiveEntry(path);
                        entry.setSize(file.size);
                        entry.setTime(file.lastModified.toDateTime().getMillis());
                        if (file.attributes.mode.isSome()) {
                            entry.setUnixMode(((UnixFileMode)file.attributes.mode.some()).toInt());
                        }
                        zos.putArchiveEntry((ArchiveEntry)entry);
                        zos.closeArchiveEntry();
                    }
                };
            }
        };
        return BasicPackageFileSystemObject.basicPackageFSO((UnixFsObject)directory, (Object)f);
    }

    private BasicPackageFileSystemObject<F2<UnixFsObject, ZipArchiveOutputStream, IoEffect>> file(final Fs<?> fromFile, UnixFsObject file) {
        F2<UnixFsObject, ZipArchiveOutputStream, IoEffect> f = new F2<UnixFsObject, ZipArchiveOutputStream, IoEffect>(){

            public IoEffect f(final UnixFsObject file, final ZipArchiveOutputStream zos) {
                return new IoEffect(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        InputStream inputStream = null;
                        Reader reader = null;
                        try {
                            P2 p = FsFileCollector.filtersAndLineEndingHandingInputStream((UnixFsObject)file, (InputStream)fromFile.inputStream());
                            inputStream = (InputStream)p._1();
                            long size = (Long)((Option)p._2()).orSome((Object)file.size);
                            ZipArchiveEntry entry = new ZipArchiveEntry(file.path.asAbsolutePath("./"));
                            entry.setSize(size);
                            entry.setTime(file.lastModified.toDateTime().getMillis());
                            if (file.attributes.mode.isSome()) {
                                entry.setUnixMode(((UnixFileMode)file.attributes.mode.some()).toInt());
                            }
                            zos.putArchiveEntry((ArchiveEntry)entry);
                            IOUtil.copy((InputStream)inputStream, (OutputStream)zos, (int)131072);
                            zos.closeArchiveEntry();
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(inputStream);
                            IOUtil.close(reader);
                            throw throwable;
                        }
                        IOUtil.close((InputStream)inputStream);
                        IOUtil.close(reader);
                    }
                };
            }
        };
        return BasicPackageFileSystemObject.basicPackageFSO((UnixFsObject)file, (Object)f);
    }

    public String getArchitecture() {
        return "";
    }

    public String getOutputFileName() {
        return "";
    }

    public class ZipPreparedPackage
    extends UnixPackage.PreparedPackage {
        public ZipPreparedPackage() {
            super((UnixPackage)ZipUnixPackage.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void packageToFile(File packageFile) throws Exception {
            F2 pathFilter = ZipUnixPackage.pathFilter();
            ZipUnixPackage.this.fileSystem = ZipUnixPackage.this.fileSystem.prettify();
            Stream items = ZipUnixPackage.this.fileSystem.toList().filter(Function.compose((F)BooleanF.invert, (F)Function.curry(pathFilter, (Object)RelativePath.BASE)));
            ZipArchiveOutputStream zos = null;
            try {
                zos = new ZipArchiveOutputStream(packageFile);
                zos.setLevel(9);
                for (PackageFileSystemObject fileSystemObject : items) {
                    ((IoEffect)((F2)fileSystemObject.getExtension()).f((Object)fileSystemObject.getUnixFsObject(), (Object)zos)).run();
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(zos);
                throw throwable;
            }
            IOUtil.close((OutputStream)zos);
        }
    }
}

