/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.io;

import com.streamsets.pipeline.api.ext.io.CountingReader;
import com.streamsets.pipeline.api.ext.io.OverrunException;
import com.streamsets.pipeline.api.impl.Utils;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;

public class OverrunReader
extends CountingReader {
    public static final String READ_LIMIT_SYS_PROP = "overrun.reader.read.limit";
    public static final String DEFAULT_READ_LIMIT = "1048576";
    private final int readLimit;
    private final boolean removeCtrlChars;
    private boolean enabled;
    private static int readLimitSysProp;
    private final char[] oneCharBuf = new char[1];

    public OverrunReader(Reader in, int readLimit, boolean overrunCheckEnabled, boolean removeCtrlChars) {
        super(in);
        this.removeCtrlChars = removeCtrlChars;
        this.readLimit = readLimit;
        this.setEnabled(overrunCheckEnabled);
    }

    public static int getDefaultReadLimit() {
        return readLimitSysProp;
    }

    public static void reInitializeDefaultReadLimit() {
        readLimitSysProp = Integer.parseInt(System.getProperty(READ_LIMIT_SYS_PROP, DEFAULT_READ_LIMIT));
    }

    public void setEnabled(boolean enabled) {
        boolean bl = this.enabled = enabled && this.readLimit > 0;
        if (enabled) {
            this.resetCount();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected synchronized void afterRead(int n) {
        super.afterRead(n);
        if (this.isEnabled() && this.getCount() > (long)this.readLimit) {
            OverrunReader.throwUndeclared(new OverrunException(Utils.format("Reader exceeded the read limit '{}'", this.readLimit), this.getPos()));
        }
    }

    @Override
    public int read() throws IOException {
        if (this.removeCtrlChars) {
            int r = this.read(this.oneCharBuf, 0, 1);
            while (r > -1 && r == 0) {
                r = this.read(this.oneCharBuf, 0, 1);
            }
            return r == -1 ? -1 : this.oneCharBuf[0];
        }
        return super.read();
    }

    @Override
    public int read(char[] buffer) throws IOException {
        if (this.removeCtrlChars) {
            return this.read(buffer, 0, buffer.length);
        }
        return super.read(buffer);
    }

    @Override
    public int read(char[] buffer, int offset, int len) throws IOException {
        if (this.removeCtrlChars) {
            char[] internalBuffer = new char[len];
            int r = super.read(internalBuffer, 0, len);
            return r == -1 ? -1 : OverrunReader.removeControlChars(internalBuffer, r, buffer, offset);
        }
        return super.read(buffer, offset, len);
    }

    @Override
    public int read(@NotNull CharBuffer target) throws IOException {
        if (this.removeCtrlChars) {
            char[] buffer = new char[target.limit()];
            int r = this.read(buffer);
            if (r > 0) {
                target.put(buffer, 0, r);
            }
            return r;
        }
        return super.read(target);
    }

    static int removeControlChars(char[] intBuffer, int len, char[] extBuffer, int offset) {
        int lenToCopy;
        int removed = 0;
        int extPos = 0;
        int pos = 0;
        int controlPos = OverrunReader.findFirstControlIdx(intBuffer, pos, len);
        while (controlPos > -1) {
            lenToCopy = controlPos - pos;
            if (lenToCopy > 0) {
                System.arraycopy(intBuffer, pos, extBuffer, offset + extPos, lenToCopy);
                extPos += lenToCopy;
            }
            pos = controlPos + 1;
            ++removed;
            controlPos = OverrunReader.findFirstControlIdx(intBuffer, pos, len);
        }
        lenToCopy = len - pos;
        if (lenToCopy > 0) {
            System.arraycopy(intBuffer, pos, extBuffer, offset + extPos, lenToCopy);
        }
        return len - removed;
    }

    static int findFirstControlIdx(char[] buffer, int start, int bufferLen) {
        int pos;
        for (pos = start; pos < bufferLen && !OverrunReader.isControl(buffer[pos]); ++pos) {
        }
        return pos == bufferLen ? -1 : pos;
    }

    static boolean isControl(char c) {
        return c == '\u007f' || c < ' ' && c != '\t' && c != '\n' && c != '\r';
    }

    private static <E extends Exception> void throwUndeclared(Throwable e) throws E {
        throw (Exception)e;
    }

    static {
        OverrunReader.reInitializeDefaultReadLimit();
    }
}

