/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.Field;
import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.ListTypeSupport;
import com.streamsets.pipeline.api.impl.MapTypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupportConversionException;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ListMapTypeSupport
extends TypeSupport<LinkedHashMap> {
    @Override
    public LinkedHashMap convert(Object value) {
        if (value instanceof LinkedHashMap) {
            return (LinkedHashMap)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            LinkedHashMap<String, Field> listMap = new LinkedHashMap<String, Field>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                listMap.put(Integer.toString(i), (Field)list.get(i));
            }
            return listMap;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new LinkedHashMap(map);
        }
        throw new TypeSupportConversionException(Errors.API_21, value.getClass().getSimpleName(), value);
    }

    @Override
    public Object convert(Object value, TypeSupport targetTypeSupport) {
        if (targetTypeSupport instanceof ListMapTypeSupport || targetTypeSupport instanceof MapTypeSupport) {
            return value;
        }
        if (targetTypeSupport instanceof ListTypeSupport && value instanceof LinkedHashMap) {
            LinkedHashMap listMap = (LinkedHashMap)value;
            return new ArrayList(listMap.values());
        }
        throw new TypeSupportConversionException(Errors.API_22, targetTypeSupport);
    }

    @Override
    public Object clone(Object value) {
        LinkedHashMap<String, Field> listMap = null;
        if (value != null) {
            listMap = ListMapTypeSupport.deepCopy((LinkedHashMap)value);
        }
        return listMap;
    }

    private static LinkedHashMap<String, Field> deepCopy(LinkedHashMap<String, Field> listMap) {
        LinkedHashMap<String, Field> copy = new LinkedHashMap<String, Field>(listMap.size());
        for (Map.Entry<String, Field> entry : listMap.entrySet()) {
            Field field = entry.getValue();
            Utils.checkNotNull(field, Utils.formatL("ListMap has null element at '{}' pos", entry.getKey()));
            copy.put(entry.getKey(), field.clone());
        }
        return copy;
    }

    @Override
    public Object create(Object value) {
        return this.clone(value);
    }
}

