/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl.annotationsprocessor;

import com.streamsets.pipeline.api.ConnectionDef;
import com.streamsets.pipeline.api.ConnectionVerifierDef;
import com.streamsets.pipeline.api.ElDef;
import com.streamsets.pipeline.api.ErrorStage;
import com.streamsets.pipeline.api.Executor;
import com.streamsets.pipeline.api.GenerateResourceBundle;
import com.streamsets.pipeline.api.HideStage;
import com.streamsets.pipeline.api.Processor;
import com.streamsets.pipeline.api.PushSource;
import com.streamsets.pipeline.api.Source;
import com.streamsets.pipeline.api.StageDef;
import com.streamsets.pipeline.api.StageType;
import com.streamsets.pipeline.api.StatsAggregatorStage;
import com.streamsets.pipeline.api.Target;
import com.streamsets.pipeline.api.credential.CredentialStoreDef;
import com.streamsets.pipeline.api.delegate.StageLibraryDelegateDef;
import com.streamsets.pipeline.api.impl.Utils;
import com.streamsets.pipeline.api.interceptor.InterceptorDef;
import com.streamsets.pipeline.api.lineage.LineagePublisherDef;
import com.streamsets.pipeline.api.service.ServiceDef;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.streamsets.pipeline.api.StageDef", "com.streamsets.pipeline.api.GenerateResourceBundle", "com.streamsets.pipeline.api.ElDef", "com.streamsets.pipeline.api.lineage.LineagePublisherDef", "com.streamsets.pipeline.api.credential.CredentialStoreDef", "com.streamsets.pipeline.api.service.ServiceDef", "com.streamsets.pipeline.api.delegate.StageLibraryDelegateDef", "com.streamsets.pipeline.api.interceptor.InterceptorDef", "com.streamsets.pipeline.api.ConnectionDef", "com.streamsets.pipeline.api.ConnectionVerifierDef"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"streamsets.datacollector.annotationsprocessor.skip"})
public class PipelineAnnotationsProcessor
extends AbstractProcessor {
    static final String SKIP_PROCESSOR = "streamsets.datacollector.annotationsprocessor.skip";
    public static final String STAGES_FILE = "PipelineStages.json";
    public static final String LINEAGE_PUBLISHERS_FILE = "LineagePublishers.json";
    public static final String SERVICES_FILE = "Services.json";
    public static final String ELDEFS_FILE = "ElDefinitions.json";
    public static final String BUNDLES_FILE = "datacollector-resource-bundles.json";
    public static final String CREDENTIAL_STORE_FILE = "CredentialStores.json";
    public static final String INTERCEPTORS_FILE = "Interceptors.json";
    public static final String STAGE_DEF_LIST_FILE = "StageDefList.json";
    public static final String DELEGATE_LIST_FILE = "Delegates.json";
    public static final String CONNECTIONS_LIST_FILE = "Connections.json";
    public static final String CONNECTION_VERIFIERS_LIST_FILE = "ConnectionVerifiers.json";
    private boolean skipProcessor;
    private ProcessingEnvironment processingEnv;
    private final List<String> stagesClasses = new ArrayList<String>();
    private final List<String> lineagePublishersClasses = new ArrayList<String>();
    private final List<String> servicesClasses = new ArrayList<String>();
    private final List<String> elDefClasses = new ArrayList<String>();
    private final List<String> bundleClasses = new ArrayList<String>();
    private final List<String> credentialStoreClasses = new ArrayList<String>();
    private final List<String> interceptorClasses = new ArrayList<String>();
    private final List<String> delegateCLasses = new ArrayList<String>();
    private final List<String> stageDefJsonList = new ArrayList<String>();
    private final List<String> connectionsClasses = new ArrayList<String>();
    private final List<String> connectionVerifiersClasses = new ArrayList<String>();
    private boolean error;
    private TypeMirror typeOfSource;
    private TypeMirror typeOfPushSource;
    private TypeMirror typeOfProcessor;
    private TypeMirror typeOfExecutor;
    private TypeMirror typeOfTarget;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.skipProcessor = processingEnv.getOptions().containsKey(SKIP_PROCESSOR);
        this.processingEnv = processingEnv;
        this.typeOfSource = processingEnv.getElementUtils().getTypeElement(Source.class.getName()).asType();
        this.typeOfPushSource = processingEnv.getElementUtils().getTypeElement(PushSource.class.getName()).asType();
        this.typeOfProcessor = processingEnv.getElementUtils().getTypeElement(Processor.class.getName()).asType();
        this.typeOfExecutor = processingEnv.getElementUtils().getTypeElement(Executor.class.getName()).asType();
        this.typeOfTarget = processingEnv.getElementUtils().getTypeElement(Target.class.getName()).asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String className;
        if (this.skipProcessor) {
            return true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(StageDef.class)) {
            StageDef stageDef = element.getAnnotation(StageDef.class);
            if (element.getKind().isClass()) {
                String className2 = ((TypeElement)element).getQualifiedName().toString();
                this.stagesClasses.add(className2);
                boolean statsAggregatorStage = element.getAnnotation(StatsAggregatorStage.class) != null;
                boolean errorStage = element.getAnnotation(ErrorStage.class) != null;
                boolean connectionVerifier = false;
                HideStage hideStageAnnotation = element.getAnnotation(HideStage.class);
                if (hideStageAnnotation != null) {
                    connectionVerifier = Arrays.stream(hideStageAnnotation.value()).anyMatch(h -> h == HideStage.Type.CONNECTION_VERIFIER);
                }
                this.stageDefJsonList.add(this.stageDefToJson(stageDef, PipelineAnnotationsProcessor.getStageName(className2), this.extractStageType(element.asType()), statsAggregatorStage, errorStage, connectionVerifier));
                continue;
            }
            this.printError("'{}' is not a class, cannot be @StageDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(LineagePublisherDef.class)) {
            if (element.getKind().isClass()) {
                this.lineagePublishersClasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @LineagePublisherDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceDef.class)) {
            if (element.getKind().isClass()) {
                this.servicesClasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @ServiceDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(CredentialStoreDef.class)) {
            if (element.getKind().isClass()) {
                this.credentialStoreClasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @CredentialStoreDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(InterceptorDef.class)) {
            if (element.getKind().isClass()) {
                this.interceptorClasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @InterceptorDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(StageLibraryDelegateDef.class)) {
            if (element.getKind().isClass()) {
                this.delegateCLasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @InterceptorDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ElDef.class)) {
            if (element.getKind().isClass()) {
                this.elDefClasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @ELDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(GenerateResourceBundle.class)) {
            if (element.getKind().isClass()) {
                this.bundleClasses.add(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            this.printError("'{}' is not a class, cannot be @GenerateResourceBundle annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ConnectionDef.class)) {
            if (element.getKind().isClass()) {
                className = ((TypeElement)element).getQualifiedName().toString();
                this.connectionsClasses.add(className);
                continue;
            }
            this.printError("'{}' is not a class, cannot be @ConnectionDef annotated", element);
            this.error = true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ConnectionVerifierDef.class)) {
            if (element.getKind().isClass()) {
                className = ((TypeElement)element).getQualifiedName().toString();
                this.connectionVerifiersClasses.add(className);
                continue;
            }
            this.printError("'{}' is not a class, cannot be @ConnectionVerifierDef annotated", element);
            this.error = true;
        }
        if (roundEnv.processingOver() && !this.error) {
            this.generateFiles();
        }
        return true;
    }

    private void printError(String template, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, Utils.format(template, args));
    }

    private void generateFiles() {
        this.generateFile(STAGES_FILE, this.stagesClasses, "  \"", "\"");
        this.generateFile(LINEAGE_PUBLISHERS_FILE, this.lineagePublishersClasses, "  \"", "\"");
        this.generateFile(SERVICES_FILE, this.servicesClasses, "  \"", "\"");
        this.generateFile(ELDEFS_FILE, this.elDefClasses, "  \"", "\"");
        this.generateFile(BUNDLES_FILE, this.bundleClasses, "  \"", "\"");
        this.generateFile(CREDENTIAL_STORE_FILE, this.credentialStoreClasses, "  \"", "\"");
        this.generateFile(INTERCEPTORS_FILE, this.interceptorClasses, "  \"", "\"");
        this.generateFile(DELEGATE_LIST_FILE, this.delegateCLasses, "  \"", "\"");
        this.generateFile(STAGE_DEF_LIST_FILE, this.stageDefJsonList, " ", "");
        this.generateFile(CONNECTIONS_LIST_FILE, this.connectionsClasses, "  \"", "\"");
        this.generateFile(CONNECTION_VERIFIERS_LIST_FILE, this.connectionVerifiersClasses, "  \"", "\"");
    }

    static String toJson(List<String> elements) {
        return PipelineAnnotationsProcessor.toJson(elements, "  \"", "\"");
    }

    private static String toJson(List<String> elements, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String separator = "\n";
        for (String e : elements) {
            sb.append(separator).append(prefix).append(e).append(postfix);
            separator = ",\n";
        }
        sb.append("\n]\n");
        return sb.toString();
    }

    private void generateFile(String fileName, List<String> elements, String prefix, String postfix) {
        try {
            FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter(resource.openOutputStream());){
                writer.write(PipelineAnnotationsProcessor.toJson(elements, prefix, postfix));
            }
        }
        catch (IOException e) {
            this.printError("Could not create/write '{}' file: {}", e.toString());
        }
    }

    private String stageDefToJson(StageDef stageDef, String stageName, StageType stageType, boolean statsAggregatorStage, boolean errorStage, boolean connectionVerifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\t\"").append("name").append("\"").append(": \"").append(stageName).append("\"");
        sb.append(",\n");
        sb.append("\t\"").append("type").append("\"").append(": \"").append((Object)stageType).append("\"");
        sb.append(",\n");
        sb.append("\t\"").append("label").append("\"").append(": \"").append(stageDef.label()).append("\"");
        sb.append(",\n");
        sb.append("\t\"").append("description").append("\"").append(": \"").append(stageDef.description()).append("\"");
        sb.append(",\n");
        sb.append("\t\"").append("version").append("\"").append(": ").append(stageDef.version());
        sb.append(",\n");
        sb.append("\t\"").append("statsAggregatorStage").append("\"").append(": ").append(statsAggregatorStage);
        sb.append(",\n");
        sb.append("\t\"").append("errorStage").append("\"").append(": ").append(errorStage);
        sb.append(",\n");
        sb.append("\t\"").append("beta").append("\"").append(": ").append(stageDef.beta());
        sb.append(",\n");
        sb.append("\t\"").append("tags").append("\"").append(": [").append(String.join((CharSequence)",", stageDef.tags())).append("]");
        sb.append(",\n");
        sb.append("\t\"").append("onlineHelpRefUrl").append("\"").append(": \"").append(stageDef.onlineHelpRefUrl()).append("\"");
        sb.append(",\n");
        sb.append("\t\"").append("icon").append("\"").append(": \"").append(stageDef.icon()).append("\"");
        sb.append(",\n");
        sb.append("\t\"").append("connectionVerifierStage").append("\"").append(": ").append(connectionVerifier);
        sb.append("\n }");
        return sb.toString();
    }

    private StageType extractStageType(TypeMirror stageType) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        StageType type = typeUtils.isAssignable(stageType, this.typeOfSource) || typeUtils.isAssignable(stageType, this.typeOfPushSource) ? StageType.SOURCE : (typeUtils.isSubtype(stageType, this.typeOfProcessor) ? StageType.PROCESSOR : (typeUtils.isSubtype(stageType, this.typeOfExecutor) ? StageType.EXECUTOR : (typeUtils.isSubtype(stageType, this.typeOfTarget) ? StageType.TARGET : null)));
        return type;
    }

    private static String getStageName(String className) {
        return className.replace(".", "_").replace("$", "_");
    }

    private String getBase64Image(StageDef stageDef) {
        String base64Image = null;
        if (stageDef.icon().length() > 0) {
            try (InputStream inputStream = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", stageDef.icon()).openInputStream();){
                int read;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, read);
                }
                byteArrayOutputStream.flush();
                base64Image = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                this.printError("Failed to convert stage icons to Base64 - " + e.getLocalizedMessage(), new Object[0]);
            }
        }
        return base64Image;
    }
}

