/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api;

import com.streamsets.pipeline.api.Constraint;
import com.streamsets.pipeline.api.Dependency;
import com.streamsets.pipeline.api.ExplorerConfigDef;
import com.streamsets.pipeline.api.Placeholder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface ConfigDef {
    public Type type();

    public Upload upload() default Upload.NO;

    public String defaultValue() default "";

    public String defaultValueFromResource() default "";

    public boolean required();

    public String label();

    public Placeholder placeholder() default @Placeholder;

    public String description() default "";

    public String group() default "";

    public int displayPosition() default 0;

    public String dependsOn() default "";

    public String[] triggeredByValue() default {};

    public Dependency[] dependencies() default {};

    public long min() default -9223372036854775808L;

    public long max() default 0x7FFFFFFFFFFFFFFFL;

    public int lines() default 0;

    public Mode mode() default Mode.PLAIN_TEXT;

    public Class[] elDefs() default {};

    public Evaluation evaluation() default Evaluation.IMPLICIT;

    public boolean stageSuggestions() default false;

    public DisplayMode displayMode() default DisplayMode.BASIC;

    public String connectionType() default "";

    public boolean requiredForExplorerLoad() default false;

    public boolean useForExplorerLoad() default false;

    public ExplorerConfigDef explorer() default @ExplorerConfigDef(explorerId="", explorerType="", schemaElement="", binding=ExplorerConfigDef.Binding.NONE);

    public Constraint[] constraints() default {};

    public static enum Upload {
        NO,
        TEXT,
        BASE64;

    }

    public static enum DisplayMode {
        BASIC,
        ADVANCED;

    }

    public static enum Evaluation {
        IMPLICIT,
        EXPLICIT;

    }

    public static enum Mode {
        JAVA,
        JAVASCRIPT,
        JSON,
        PLAIN_TEXT,
        PYTHON,
        RUBY,
        SCALA,
        SQL,
        GROOVY,
        SHELL,
        KOTLIN;

    }

    public static enum Type {
        BOOLEAN(false),
        NUMBER(0),
        STRING(""),
        LIST(Collections.emptyList()),
        MAP(Collections.emptyList()),
        MODEL(""),
        CHARACTER(Character.valueOf(' ')),
        TEXT(""),
        CREDENTIAL(""),
        RUNTIME(null);

        private final transient Object defaultValue;

        private Type(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object getDefault(Class variableClass) {
            Object value = variableClass.isEnum() ? variableClass.getEnumConstants()[0] : (Map.class.isAssignableFrom(variableClass) ? Collections.emptyMap() : (List.class.isAssignableFrom(variableClass) ? Collections.emptyList() : this.defaultValue));
            return value;
        }
    }
}

