/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.json;

import com.streamsets.pipeline.api.ext.json.JsonRule;
import com.streamsets.pipeline.api.ext.json.JsonRuleParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface JsonDelegate<T> {
    public JsonRule annotation();

    public String serialize(T var1, Map<String, Object> var2);

    public T deserialize(String var1, Map<String, Object> var2);

    default public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        for (JsonRuleParameter parameter : this.annotation().parameters()) {
            parameters.add(parameter.name());
        }
        return parameters;
    }

    default public Object findOption(Map<String, Object> options, String name) {
        Object option = null;
        for (JsonRuleParameter parameter : this.annotation().parameters()) {
            if (!parameter.key().equals(name)) continue;
            option = options.get(parameter.name());
            break;
        }
        return option;
    }

    default public String getPattern(Map<String, Object> options) {
        Object option = this.findOption(options, "pattern");
        return option == null ? null : (String)option;
    }

    default public boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static abstract class Parameters {
        public static final String PATTERN = "pattern";
    }
}

