/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.json.delegate;

import com.streamsets.pipeline.api.ext.json.JsonDelegate;
import com.streamsets.pipeline.api.ext.json.JsonRule;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class ZonedDateTimeDelegate
implements JsonDelegate<ZonedDateTime> {
    private final JsonRule annotation;

    public ZonedDateTimeDelegate(JsonRule annotation) {
        this.annotation = annotation;
    }

    @Override
    public JsonRule annotation() {
        return this.annotation;
    }

    @Override
    public String serialize(ZonedDateTime value, Map<String, Object> options) {
        return value == null ? null : this.getFormatter(options).format(value);
    }

    @Override
    public ZonedDateTime deserialize(String value, Map<String, Object> options) {
        return ZonedDateTime.parse(value, this.getFormatter(options));
    }

    private final DateTimeFormatter getFormatter(Map<String, Object> options) {
        String pattern;
        DateTimeFormatter formatter = this.isEmpty(this.annotation.pattern()) ? ((pattern = this.getPattern(options)) == null ? DateTimeFormatter.ISO_DATE_TIME : DateTimeFormatter.ofPattern(pattern)) : DateTimeFormatter.ofPattern(this.annotation.pattern());
        return formatter;
    }
}

