/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupportConversionException;
import com.streamsets.pipeline.api.impl.Utils;
import java.text.ParseException;
import java.util.Date;

public class DateTypeSupport
extends TypeSupport<Date> {
    @Override
    public Date convert(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof String) {
            try {
                return Utils.parse((String)value);
            }
            catch (ParseException ex) {
                throw new TypeSupportConversionException(Errors.API_06, value);
            }
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Integer) {
            return new Date(((Integer)value).intValue());
        }
        throw new TypeSupportConversionException(Errors.API_07, value.getClass().getSimpleName(), value);
    }

    @Override
    public Object create(Object value) {
        return this.clone(value);
    }

    @Override
    public Object get(Object value) {
        return this.clone(value);
    }

    @Override
    public Object clone(Object value) {
        return new Date(((Date)value).getTime());
    }
}

