/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.AntennaDoctorMessage;
import com.streamsets.pipeline.api.ErrorCode;
import com.streamsets.pipeline.api.StageException;
import com.streamsets.pipeline.api.impl.LocalizableMessage;
import com.streamsets.pipeline.api.impl.LocalizableString;
import com.streamsets.pipeline.api.impl.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;

public class ErrorMessage
implements LocalizableString {
    private static final Object[] NULL_ONE_ARG = new Object[]{null};
    private final String errorCode;
    private final LocalizableString errorMessage;
    private final long timestamp;
    private final boolean prependErrorCode;
    private final String stackTrace;
    private final List<AntennaDoctorMessage> antennaDoctorMessages;

    public ErrorMessage(final StageException ex) {
        this.errorCode = ex.getErrorCode().getCode();
        this.timestamp = System.currentTimeMillis();
        this.stackTrace = ErrorMessage.toStackTrace(ex);
        this.errorMessage = new LocalizableString(){

            @Override
            public String getNonLocalized() {
                return ex.getMessage();
            }

            @Override
            public String getLocalized() {
                return ex.getLocalizedMessage();
            }

            @Override
            public String getHumanReadableMessage() {
                return ex.getErrorCode().getMessage();
            }

            @Override
            public String getTechnicalMessage() {
                return ex.getErrorCode().getTechnicalMessage();
            }

            @Override
            public String getRemediationSteps() {
                return ex.getErrorCode().getRemediationSteps();
            }
        };
        this.prependErrorCode = false;
        this.antennaDoctorMessages = Collections.emptyList();
    }

    public ErrorMessage(String errorCode, final String nonLocalizedMsg, long timestamp) {
        this.errorCode = errorCode;
        this.errorMessage = new LocalizableString(){

            @Override
            public String getNonLocalized() {
                return nonLocalizedMsg;
            }

            @Override
            public String getLocalized() {
                return nonLocalizedMsg;
            }
        };
        this.timestamp = timestamp;
        this.stackTrace = null;
        this.prependErrorCode = true;
        this.antennaDoctorMessages = Collections.emptyList();
    }

    public ErrorMessage(List<AntennaDoctorMessage> antennaDoctorMessages, ErrorCode errorCode, Object ... params) {
        this(antennaDoctorMessages, Utils.checkNotNull(errorCode, "errorCode").getClass().getName() + "-bundle", errorCode, params);
    }

    public ErrorMessage(ErrorCode errorCode, Object ... params) {
        this(Collections.emptyList(), Utils.checkNotNull(errorCode, "errorCode").getClass().getName() + "-bundle", errorCode, params);
    }

    public ErrorMessage(String resourceBundle, ErrorCode errorCode, Object ... params) {
        this(Collections.emptyList(), resourceBundle, errorCode, params);
    }

    public List<AntennaDoctorMessage> getAntennaDoctorMessages() {
        return this.antennaDoctorMessages;
    }

    public ErrorMessage(List<AntennaDoctorMessage> antennaDoctorMessages, String resourceBundle, ErrorCode errorCode, Object ... params) {
        this.errorCode = Utils.checkNotNull(errorCode, "errorCode").getCode();
        this.stackTrace = params != null && params.length > 0 && params[params.length - 1] instanceof Throwable ? ErrorMessage.toStackTrace((Throwable)params[params.length - 1]) : null;
        this.errorMessage = new LocalizableMessage(errorCode.getClass().getClassLoader(), resourceBundle, errorCode, params != null ? params : NULL_ONE_ARG);
        this.timestamp = System.currentTimeMillis();
        this.prependErrorCode = true;
        this.antennaDoctorMessages = Collections.unmodifiableList(antennaDoctorMessages);
    }

    public static String toStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public String getErrorStackTrace() {
        return this.stackTrace;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getNonLocalized() {
        return this.prependErrorCode ? Utils.format("{} - {}", this.getErrorCode(), this.errorMessage.getNonLocalized()) : this.errorMessage.getNonLocalized();
    }

    @Override
    public String getLocalized() {
        return this.prependErrorCode ? Utils.format("{} - {}", this.getErrorCode(), this.errorMessage.getLocalized()) : this.errorMessage.getLocalized();
    }

    @Override
    public String getTechnicalMessage() {
        return this.errorMessage.getTechnicalMessage();
    }

    @Override
    public String getRemediationSteps() {
        return this.errorMessage.getRemediationSteps();
    }

    @Override
    public String getHumanReadableMessage() {
        return this.errorMessage.getHumanReadableMessage();
    }

    public String toString() {
        return this.getNonLocalized();
    }
}

