/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private static final Map<String, String[]> TEMPLATES = new ConcurrentHashMap<String, String[]>();
    private static final String TOKEN = "{}";
    private static final String PADDING = "000000000000000000000000000000000000";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String ISO8601_UTC_MASK = "yyyy-MM-dd'T'HH:mm'Z'";
    private static Callable<String> sdcIdCallable;

    Utils() {
    }

    public static <T> T checkNotNull(@Nullable T value, Object varName) {
        if (value == null) {
            throw new NullPointerException(Utils.format("{} cannot be null", varName));
        }
        return value;
    }

    public static void checkArgument(boolean expression, @Nullable Object msg) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(msg));
        }
    }

    public static void checkState(boolean expression, @Nullable Object msg) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(msg));
        }
    }

    static String[] prepareTemplate(String template) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        int nextToken = template.indexOf(TOKEN, pos);
        while (nextToken > -1 && pos < template.length()) {
            list.add(template.substring(pos, nextToken));
            pos = nextToken + TOKEN.length();
            nextToken = template.indexOf(TOKEN, pos);
        }
        list.add(template.substring(pos));
        return list.toArray(new String[list.size()]);
    }

    public static String format(String template, Object ... args) {
        String[] templateArr = TEMPLATES.get(template);
        if (templateArr == null) {
            templateArr = Utils.prepareTemplate(template);
            TEMPLATES.put(template, templateArr);
        }
        StringBuilder sb = new StringBuilder(template.length() * 2);
        for (int i = 0; i < templateArr.length; ++i) {
            sb.append(templateArr[i]);
            if (args == null || i >= templateArr.length - 1) continue;
            sb.append(i < args.length ? args[i] : TOKEN);
        }
        return sb.toString();
    }

    public static Object formatL(final String template, final Object ... args) {
        return new Object(){

            public String toString() {
                return Utils.format(template, args);
            }
        };
    }

    public static String intToPaddedString(int value, int pad) {
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        int padding = pad - sb.length();
        if (padding > 0) {
            sb.insert(0, PADDING.subSequence(0, padding));
        }
        return sb.toString();
    }

    private static DateFormat getISO8601DateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO8601_UTC_MASK);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(UTC);
        return dateFormat;
    }

    public static Date parse(String str) throws ParseException {
        return Utils.getISO8601DateFormat().parse(str);
    }

    public static ZonedDateTime parseZoned(String str) {
        return ZonedDateTime.parse(str, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static String format(ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static String humanReadableInt(long number) {
        String suffix;
        double result;
        String prefix;
        DecimalFormat oneDecimal = new DecimalFormat("0.0");
        long absNumber = Math.abs(number);
        String string = prefix = number < 0L ? "-" : "";
        if (absNumber < 1000L) {
            return number + " bytes";
        }
        if ((double)absNumber < 1000000.0) {
            result = (double)number / 1000.0;
            suffix = " KB";
        } else if ((double)absNumber < 1.0E9) {
            result = (double)number / 1000000.0;
            suffix = " MB";
        } else {
            result = (double)number / 1.0E9;
            suffix = " GB";
        }
        return prefix + oneDecimal.format(result) + suffix;
    }

    public static void setSdcIdCallable(Callable<String> callable) {
        sdcIdCallable = callable;
    }

    public static String getSdcId() {
        Utils.checkState(sdcIdCallable != null, "sdcIdCallable has not been set");
        try {
            return sdcIdCallable.call();
        }
        catch (Exception ex) {
            throw new RuntimeException(Utils.format("SDC ID Callable threw an unexpected exception: {}", ex.toString(), ex));
        }
    }
}

