/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.systemexplorer.api;

import com.streamsets.pipeline.api.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExplorerSchema {
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+");
    private final Set root;
    private final java.util.Set<String> elementNames;
    private final Map<String, List<String>> parents;

    private ExplorerSchema() {
        this.root = null;
        this.elementNames = Collections.emptySet();
        this.parents = Collections.emptyMap();
    }

    protected ExplorerSchema(Element element, Element ... elements) {
        Utils.checkNotNull(element, "element");
        ArrayList<Element> elementList = new ArrayList<Element>();
        elementList.add(element);
        elementList.addAll(Arrays.asList(elements));
        this.root = new Set(true, "", "", true, false, elementList, Collections.emptyMap(), Collections.singletonList(new Attribute("name", "name")));
        ArrayList names = new ArrayList();
        this.visit(this.root, e -> names.addAll(this.getSchemaElementNames((Element)e)));
        java.util.Set dupNames = names.stream().filter(name -> Collections.frequency(names, name) > 1).collect(Collectors.toSet());
        if (!dupNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("ExplorerSchema '%s' has duplicate elements: '%s'", this.getClass().getSimpleName(), dupNames));
        }
        this.elementNames = Collections.unmodifiableSet(new HashSet(names));
        this.parents = this.elementNames.stream().collect(Collectors.toMap(name -> name, name -> {
            ArrayList<String> list = new ArrayList<String>();
            ExplorerSchema.findParents(this.getRoot().getElements(), name, list);
            return Collections.unmodifiableList(list);
        }));
    }

    private void visit(Element element, Consumer<Element> visitor) {
        visitor.accept(element);
        element.asSet().ifPresent(set -> set.getElements().forEach(e -> this.visit((Element)e, visitor)));
    }

    private List<String> getSchemaElementNames(Element element) {
        return element.getName().isEmpty() ? Collections.emptyList() : Stream.concat(Stream.of(element.getName()), element.getAdditionalNamesIcons().keySet().stream()).collect(Collectors.toList());
    }

    private static boolean findParents(List<Element> schemaElements, String name, List<String> parents) {
        boolean found = false;
        for (Element schemaElement : schemaElements) {
            if ((found |= schemaElement.getName().equals(name)) || !(schemaElement instanceof Set) || !ExplorerSchema.findParents(((Set)schemaElement).getElements(), name, parents)) continue;
            parents.add(0, schemaElement.getName());
            return true;
        }
        return found;
    }

    public Set getRoot() {
        return this.root;
    }

    public java.util.Set<String> getElementNames() {
        return this.elementNames;
    }

    public List<String> getParents(String elementName) {
        return this.parents.get(Utils.checkNotNull(elementName, "elementName"));
    }

    private Element findElement(Element element, String name) {
        if (element.getName().equals(name)) {
            return element;
        }
        if (element.asSet().isPresent()) {
            for (Element child : element.asSet().get().getElements()) {
                element = this.findElement(child, name);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    private java.util.Set<String> getChildrenName(Element element, int upToChildDepth) {
        if (upToChildDepth == 0 || element.asAtom().isPresent()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        element.asSet().get().getElements().forEach(e -> {
            names.add(e.getName());
            names.addAll(this.getChildrenName((Element)e, upToChildDepth - 1));
        });
        return names;
    }

    public java.util.Set<String> getChildrenNames(String name, int upToChildDepth) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(upToChildDepth >= 0, "upToChildDepth must be >= 0");
        Element element = this.findElement(this.getRoot(), name);
        if (element == null) {
            throw new IllegalArgumentException(Utils.format("ExplorerSchema '{}' element '{}' does not exist", this.getClass().getSimpleName(), name));
        }
        return this.getChildrenName(element, upToChildDepth);
    }

    public String toString() {
        return "ExplorerSchema{root=" + this.root + '}';
    }

    public static class Set
    extends Element {
        private final List<Element> elements;
        private final boolean recursive;

        private Set(boolean root, String name, String icon, boolean cacheable, boolean recursive, List<Element> elements, Map<String, String> additionaNamesIcons, List<Attribute> attributes) {
            super(root, name, Utils.checkNotNull(icon, "icon"), cacheable, additionaNamesIcons, attributes);
            Utils.checkNotNull(elements, "elements");
            ArrayList<Element> list = new ArrayList<Element>();
            if (recursive) {
                Utils.checkArgument(elements.size() == 0, "elements");
            } else {
                list.addAll(elements);
            }
            this.elements = Collections.unmodifiableList(list);
            this.recursive = recursive;
        }

        public List<Element> getElements() {
            return this.elements;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public String toString() {
            return "Set{names='" + this.getName() + '\'' + ", icons='" + this.getIcon() + "', elements ='" + this.elements + '\'' + '}';
        }
    }

    public static class Attribute {
        private final String name;
        private final String label;

        public Attribute(String name, String label) {
            Utils.checkArgument(name != null, "name");
            Utils.checkArgument(label != null, "label");
            this.name = name;
            this.label = label;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static abstract class Element {
        public static final String NAME_ATTR = "name";
        private final String name;
        private final String icon;
        private final boolean cacheable;
        private final Map<String, String> additionalNamesIcons;
        private final List<Attribute> attributes;

        protected Element(boolean root, String name, String icon, boolean cacheable, Map<String, String> additionalNamesIcons, List<Attribute> attributes) {
            Utils.checkNotNull(attributes, "attributes");
            Utils.checkArgument(!attributes.isEmpty(), "attributes");
            Utils.checkArgument(attributes.stream().anyMatch(a -> ((Attribute)a).name.equals(NAME_ATTR)), String.format("%s is required", NAME_ATTR));
            Utils.checkArgument(new HashSet<Attribute>(attributes).size() == attributes.size(), String.format("Attribute names should be unique: %s", attributes.stream().map(a -> ((Attribute)a).name).collect(Collectors.joining(","))));
            this.name = root ? name : this.checkName(name);
            this.icon = icon;
            this.cacheable = cacheable;
            this.additionalNamesIcons = Collections.unmodifiableMap(additionalNamesIcons.entrySet().stream().map(e -> new String[]{this.checkName((String)e.getKey()), (String)e.getValue()}).collect(Collectors.toMap(a -> a[0], a -> a[1])));
            this.attributes = Collections.unmodifiableList(attributes);
        }

        String checkName(String name) {
            Utils.checkArgument(WORD_PATTERN.matcher(name).matches(), Utils.format("ExplorerSchema '{}' invalid schema element name '{}', must be a word", this.getClass().getSimpleName(), name));
            return name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public Map<String, String> getAdditionalNamesIcons() {
            return this.additionalNamesIcons;
        }

        public Optional<Atom> asAtom() {
            return Optional.ofNullable(this instanceof Atom ? (Atom)this : null);
        }

        public Optional<Set> asSet() {
            return Optional.ofNullable(this instanceof Set ? (Set)this : null);
        }
    }

    public static class ElementBuilder {
        public static LastAtomBuilder atom(String name) {
            return new ElementBuilder().createAtomBuilder(name);
        }

        public static LastSetBuilder set(String name) {
            return new ElementBuilder().createSetBuilder(name);
        }

        private ElementBuilder() {
        }

        private LastAtomBuilder createAtomBuilder(String name) {
            return new LastAtomBuilder(name);
        }

        private LastSetBuilder createSetBuilder(String name) {
            return new LastSetBuilder(name);
        }

        public static class LastAtomBuilder
        extends BaseAtomBuilder<LastAtomBuilder> {
            private LastAtomBuilder(String name) {
                super(name);
            }

            public Atom endAtom() {
                return new Atom(((Atom)this.element).getName(), ((Atom)this.element).getIcon(), ((Atom)this.element).isCacheable(), ((Atom)this.element).getAdditionalNamesIcons(), ((Atom)this.element).getAttributes());
            }
        }

        public static class LastSetBuilder
        extends BaseSetBuilder<LastSetBuilder> {
            public LastSetBuilder(String name) {
                super(name);
            }

            public Set endSet() {
                return this.build(this.builders.stream().map(b -> b.element).collect(Collectors.toList()));
            }
        }

        public static class SetBuilder<P>
        extends BaseSetBuilder<SetBuilder<P>> {
            private final P parent;

            public SetBuilder(P parent, String name) {
                super(name);
                this.parent = parent;
            }

            public P endSet() {
                this.element = this.build(this.builders.stream().map(b -> b.element).collect(Collectors.toList()));
                return this.parent;
            }
        }

        public static class BaseSetBuilder<C extends BaseSetBuilder>
        extends BaseElementBuilder<Set> {
            protected final List<BaseElementBuilder> builders = new ArrayList<BaseElementBuilder>();

            public BaseSetBuilder(String name) {
                super(new Set(false, name, "", true, false, Collections.emptyList(), Collections.emptyMap(), Collections.singletonList(new Attribute("name", "name"))), null);
            }

            public C icon(String icon) {
                this.element = new Set(false, ((Set)this.element).getName(), icon, ((Set)this.element).isCacheable(), ((Set)this.element).isRecursive(), Collections.emptyList(), ((Set)this.element).getAdditionalNamesIcons(), ((Set)this.element).getAttributes());
                return (C)this;
            }

            public C cacheable(boolean cacheable) {
                this.element = new Set(false, ((Set)this.element).getName(), ((Set)this.element).getIcon(), cacheable, ((Set)this.element).isRecursive(), Collections.emptyList(), ((Set)this.element).getAdditionalNamesIcons(), ((Set)this.element).getAttributes());
                return (C)this;
            }

            public C also(String name) {
                return this.also(name, "");
            }

            public C also(String name, String icon) {
                this.element = new Set(false, ((Set)this.element).getName(), ((Set)this.element).getIcon(), ((Set)this.element).isCacheable(), ((Set)this.element).isRecursive(), Collections.emptyList(), this.addAdditionalNameIcon(name, icon), ((Set)this.element).getAttributes());
                return (C)this;
            }

            public C attribute(String attributeName, String attributeLabel) {
                this.element = new Set(false, ((Set)this.element).getName(), ((Set)this.element).getIcon(), ((Set)this.element).isCacheable(), ((Set)this.element).isRecursive(), Collections.emptyList(), ((Set)this.element).getAdditionalNamesIcons(), this.addAttribute(attributeName, attributeLabel));
                return (C)this;
            }

            public C attribute(String attributeName) {
                return this.attribute(attributeName, attributeName);
            }

            public AtomBuilder<C> atom(String name) {
                AtomBuilder atomBuilder = new AtomBuilder(this, name);
                this.builders.add(atomBuilder);
                return atomBuilder;
            }

            public SetBuilder<C> set(String name) {
                SetBuilder<BaseSetBuilder> elementBuilder = new SetBuilder<BaseSetBuilder>(this, name);
                this.builders.add(elementBuilder);
                return elementBuilder;
            }

            protected Set build(List<Element> elements) {
                return new Set(false, ((Set)this.element).getName(), ((Set)this.element).getIcon(), ((Set)this.element).isCacheable(), ((Set)this.element).isRecursive(), elements, ((Set)this.element).getAdditionalNamesIcons(), ((Set)this.element).getAttributes());
            }
        }

        public static class AtomBuilder<P>
        extends BaseAtomBuilder<AtomBuilder<P>> {
            private final P parent;

            private AtomBuilder(P parent, String name) {
                super(name);
                this.parent = parent;
            }

            public P endAtom() {
                return this.parent;
            }
        }

        public static abstract class BaseAtomBuilder<C extends BaseAtomBuilder>
        extends BaseElementBuilder<Atom> {
            private BaseAtomBuilder(String name) {
                super(new Atom(name, "", true, new HashMap(), Collections.singletonList(new Attribute("name", "name"))), null);
            }

            public C icon(String icon) {
                this.element = new Atom(((Atom)this.element).getName(), icon, ((Atom)this.element).isCacheable(), ((Atom)this.element).getAdditionalNamesIcons(), ((Atom)this.element).getAttributes());
                return (C)this;
            }

            public C cacheable(boolean cacheable) {
                this.element = new Atom(((Atom)this.element).getName(), ((Atom)this.element).getIcon(), cacheable, ((Atom)this.element).getAdditionalNamesIcons(), ((Atom)this.element).getAttributes());
                return (C)this;
            }

            public C also(String name) {
                return this.also(name, "");
            }

            public C also(String name, String icon) {
                this.element = new Atom(((Atom)this.element).getName(), ((Atom)this.element).getIcon(), ((Atom)this.element).isCacheable(), this.addAdditionalNameIcon(name, icon), ((Atom)this.element).getAttributes());
                return (C)this;
            }

            public C attribute(String attributeName, String attributeLabel) {
                this.element = new Atom(((Atom)this.element).getName(), ((Atom)this.element).getIcon(), ((Atom)this.element).isCacheable(), ((Atom)this.element).getAdditionalNamesIcons(), this.addAttribute(attributeName, attributeLabel));
                return (C)this;
            }

            public C attribute(String attributeName) {
                return this.attribute(attributeName, attributeName);
            }
        }

        public static abstract class BaseElementBuilder<E extends Element> {
            protected E element;

            private BaseElementBuilder(E element) {
                this.element = element;
            }

            protected List<Attribute> addAttribute(String attributeName, String attributeLabel) {
                Utils.checkNotNull(attributeName, "attributeName");
                Utils.checkArgument(((Element)this.element).getAttributes().stream().noneMatch(a -> ((Attribute)a).name.equals(attributeName)), String.format("%s has already been added to the list of attribute names", attributeName));
                ArrayList<Attribute> attributes = new ArrayList<Attribute>(((Element)this.element).getAttributes());
                attributes.add(new Attribute(attributeName, attributeLabel));
                return attributes;
            }

            protected Map<String, String> addAdditionalNameIcon(String name, String icon) {
                Utils.checkNotNull(name, "name");
                Utils.checkNotNull(icon, "icon");
                HashMap<String, String> additionalNamesIcons = new HashMap<String, String>(((Element)this.element).getAdditionalNamesIcons());
                additionalNamesIcons.put(name, icon);
                return additionalNamesIcons;
            }

            /* synthetic */ BaseElementBuilder(Element x0, 1 x1) {
                this(x0);
            }
        }
    }

    public static class Atom
    extends Element {
        private Atom(String name, String icon, boolean cacheable, Map<String, String> additionalNames, List<Attribute> attributeNames) {
            super(false, name, Utils.checkNotNull(icon, "icon"), cacheable, additionalNames, attributeNames);
        }

        public String toString() {
            return "Atom{name='" + this.getName() + '\'' + ", icon='" + this.getIcon() + '\'' + '}';
        }
    }

    public static final class None
    extends ExplorerSchema {
        public static None NONE = new None();

        private None() {
        }
    }
}

