/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.systemexplorer.api;

import com.streamsets.pipeline.api.ConfigIssue;
import com.streamsets.pipeline.api.impl.Utils;
import com.streamsets.systemexplorer.api.ExplorerLoaderContext;
import com.streamsets.systemexplorer.api.ExplorerRequestContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ExplorerSearcher<T, C> {
    default public List<ConfigIssue> init(ExplorerRequestContext<C> explorerRequestContext) {
        return Collections.emptyList();
    }

    public Tree search(ExplorerLoaderContext<T> var1, SearchRequest var2) throws InterruptedException, ExplorerSearcherException;

    default public void destroy() {
    }

    public static class ExplorerSearcherException
    extends Exception {
        public ExplorerSearcherException() {
        }

        public ExplorerSearcherException(String message) {
            super(message);
        }

        public ExplorerSearcherException(String message, Throwable cause) {
            super(message, cause);
        }

        public ExplorerSearcherException(Throwable cause) {
            super(cause);
        }

        public ExplorerSearcherException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }

    public static final class NoOp
    implements ExplorerSearcher<Object, Void> {
        public static final NoOp NOOP = new NoOp();

        private NoOp() {
        }

        @Override
        public Tree search(ExplorerLoaderContext<Object> explorerLoaderContext, SearchRequest searchRequest) {
            return Tree.root();
        }
    }

    public static interface SearchRequest {
        public String getSchemaElement();

        public Map<String, String> getFixedSchemaElements();

        public String getSearch();

        public int getExtraDepth();

        public boolean isUpTruncate();

        public int getOffset();

        public int getLen();
    }

    public static class Tree {
        private final Map<String, String> attributes;
        private final String type;
        private Map<String, Tree> children;

        public static Tree root() {
            return new Tree();
        }

        private Tree() {
            this.attributes = null;
            this.type = null;
        }

        public Tree(String name, String type) {
            this(Collections.singletonMap("name", name), type);
        }

        public Tree(Map<String, String> attributes, String type) {
            this.type = Utils.checkNotNull(type, "type");
            Utils.checkNotNull(attributes, "attributes");
            Utils.checkArgument(attributes.get("name") != null, "At least the name attribute is required");
            this.attributes = Collections.unmodifiableMap(new HashMap<String, String>(attributes));
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getName() {
            return Optional.ofNullable(this.attributes).map(a -> (String)a.get("name")).orElse(null);
        }

        public String getType() {
            return this.type;
        }

        public Tree addChild(Tree tree) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, Tree>();
            }
            this.children.put(tree.getName(), tree);
            return this;
        }

        public Tree getChild(String value) {
            return this.children == null ? null : this.children.get(value);
        }

        public Collection<Tree> getChildren() {
            return this.children == null ? null : this.children.values();
        }

        public String toString() {
            return "Tree{name='" + this.getName() + '\'' + ", type='" + this.type + '\'' + ", children=" + this.children + '}';
        }
    }
}

