/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api;

import com.streamsets.pipeline.api.AntennaDoctorMessage;
import com.streamsets.pipeline.api.ErrorCode;
import com.streamsets.pipeline.api.impl.ErrorMessage;
import java.util.List;

public class StageException
extends RuntimeException {
    private final transient ErrorCode errorCode;
    private final transient ErrorMessage errorMessage;
    private final transient Object[] params;
    private List<AntennaDoctorMessage> antennaDoctorMessages;

    public StageException(ErrorCode errorCode, Object ... params) {
        this.errorCode = errorCode;
        this.params = params;
        this.antennaDoctorMessages = null;
        this.errorMessage = new ErrorMessage(errorCode, params);
        Throwable cause = StageException.getCause(params);
        if (cause != null) {
            this.initCause(cause);
        }
    }

    private static Throwable getCause(Object ... params) {
        Throwable throwable = null;
        if (params.length > 0 && params[params.length - 1] instanceof Throwable) {
            throwable = (Throwable)params[params.length - 1];
        }
        return throwable;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public String getMessage() {
        return this.errorMessage.getNonLocalized();
    }

    @Override
    public String getLocalizedMessage() {
        return this.errorMessage.getLocalized();
    }

    public List<AntennaDoctorMessage> getAntennaDoctorMessages() {
        return this.antennaDoctorMessages;
    }

    public void setAntennaDoctorMessages(List<AntennaDoctorMessage> antennaDoctorMessages) {
        this.antennaDoctorMessages = antennaDoctorMessages;
    }
}

