/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.base;

import com.streamsets.pipeline.api.Batch;
import com.streamsets.pipeline.api.Record;
import com.streamsets.pipeline.api.StageException;
import com.streamsets.pipeline.api.Target;
import com.streamsets.pipeline.api.base.BaseTarget;
import com.streamsets.pipeline.api.base.OnRecordErrorException;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.Iterator;

public abstract class RecordTarget
extends BaseTarget {
    @Override
    public void write(Batch batch) throws StageException {
        Iterator<Record> it = batch.getRecords();
        if (it.hasNext()) {
            block7: while (it.hasNext()) {
                Record record = it.next();
                try {
                    this.write(record);
                }
                catch (OnRecordErrorException ex) {
                    switch (((Target.Context)this.getContext()).getOnErrorRecord()) {
                        case DISCARD: {
                            continue block7;
                        }
                        case TO_ERROR: {
                            ((Target.Context)this.getContext()).toError(record, ex);
                            continue block7;
                        }
                        case STOP_PIPELINE: {
                            throw ex;
                        }
                    }
                    throw new IllegalStateException(Utils.format("It should never happen. OnError '{}'", ((Target.Context)this.getContext()).getOnErrorRecord(), ex));
                }
            }
        } else {
            this.emptyBatch();
        }
    }

    protected abstract void write(Record var1) throws StageException;

    protected void emptyBatch() throws StageException {
    }
}

