/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.el;

import com.streamsets.pipeline.api.el.ELEvalException;
import com.streamsets.pipeline.api.el.ELVars;
import com.streamsets.pipeline.api.impl.Utils;

public abstract class ELEval {
    private static final ThreadLocal<ELVars> VARIABLES_IN_SCOPE_TL = new ThreadLocal();

    public abstract String getConfigName();

    public abstract ELVars createVariables();

    protected abstract <T> T evaluate(ELVars var1, String var2, Class<T> var3) throws ELEvalException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T eval(ELVars vars, String el, Class<T> returnType) throws ELEvalException {
        Utils.checkNotNull(vars, "vars");
        Utils.checkNotNull(el, "expression");
        Utils.checkNotNull(returnType, "returnType");
        VARIABLES_IN_SCOPE_TL.set(vars);
        try {
            T t = this.evaluate(vars, el, returnType);
            return t;
        }
        finally {
            VARIABLES_IN_SCOPE_TL.set(null);
        }
    }

    public static ELVars getVariablesInScope() {
        return VARIABLES_IN_SCOPE_TL.get();
    }
}

