/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.json;

import com.streamsets.pipeline.api.ext.json.JsonDelegate;
import com.streamsets.pipeline.api.ext.json.JsonRuleParameter;
import com.streamsets.pipeline.api.ext.json.delegate.ClassDelegate;
import com.streamsets.pipeline.api.ext.json.delegate.LocalDateTimeDelegate;
import com.streamsets.pipeline.api.ext.json.delegate.ZonedDateTimeDelegate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface JsonRule {
    public Strategy strategy() default Strategy.BUILTIN;

    public Format format() default Format.NONE;

    public String pattern() default "";

    public JsonRuleParameter[] parameters() default {};

    public Class<? extends JsonDelegate> delegate() default JsonDelegate.class;

    public static enum Format {
        NONE(null),
        CLASS(ClassDelegate.class),
        LOCAL_DATE_TIME(LocalDateTimeDelegate.class),
        ZONED_DATE_TIME(ZonedDateTimeDelegate.class);

        private Class<? extends JsonDelegate> delegate;

        private Format(Class<? extends JsonDelegate> delegate) {
            this.delegate = delegate;
        }

        public Class<? extends JsonDelegate> delegate() {
            return this.delegate;
        }
    }

    public static enum Strategy {
        BUILTIN,
        DELEGATED;

    }
}

