/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.json.delegate;

import com.streamsets.pipeline.api.ext.json.JsonDelegate;
import com.streamsets.pipeline.api.ext.json.JsonException;
import com.streamsets.pipeline.api.ext.json.JsonRule;
import java.util.Map;

public class ClassDelegate
implements JsonDelegate<Class> {
    private final JsonRule annotation;

    public ClassDelegate(JsonRule annotation) {
        this.annotation = annotation;
    }

    @Override
    public JsonRule annotation() {
        return this.annotation;
    }

    @Override
    public String serialize(Class clazz, Map<String, Object> options) {
        return clazz == null ? null : clazz.getName();
    }

    @Override
    public Class deserialize(String value, Map<String, Object> options) {
        ClassLoader workingClassLoader = this.getClassLoader(options);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader containerClassloader = workingClassLoader != null ? workingClassLoader : currentClassLoader;
        try {
            if (workingClassLoader != null) {
                Thread.currentThread().setContextClassLoader(workingClassLoader);
            }
            try {
                Class<?> clazz = value == null ? null : Class.forName(value, true, containerClassloader);
                return clazz;
            }
            catch (ClassNotFoundException exception) {
                throw new JsonException(String.format("Class %s not found in your specified class loader", value), exception);
            }
        }
        finally {
            if (workingClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    private final ClassLoader getClassLoader(Map<String, Object> options) {
        Object classLoader = this.findOption(options, "$classLoader");
        return classLoader == null ? null : (ClassLoader)classLoader;
    }

    public static interface Parameters {
        public static final String CLASS_LOADER = "$classLoader";
    }
}

