/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupportConversionException;

public class ByteArrayTypeSupport
extends TypeSupport<byte[]> {
    @Override
    public byte[] convert(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new TypeSupportConversionException(Errors.API_02, value.getClass().getSimpleName(), value);
    }

    @Override
    public Object convert(Object value, TypeSupport targetTypeSupport) {
        if (targetTypeSupport instanceof ByteArrayTypeSupport) {
            return value;
        }
        throw new TypeSupportConversionException(Errors.API_03, targetTypeSupport);
    }

    @Override
    public Object create(Object value) {
        return this.clone(value);
    }

    @Override
    public Object get(Object value) {
        return this.clone(value);
    }

    @Override
    public Object clone(Object value) {
        return ((byte[])value).clone();
    }

    @Override
    public boolean equals(Object value1, Object value2) {
        return value1 == value2 || value1 != null && value2 != null && ByteArrayTypeSupport.arrayEquals((byte[])value1, (byte[])value2);
    }

    private static boolean arrayEquals(byte[] arr1, byte[] arr2) {
        boolean eq = false;
        if (arr1.length == arr2.length) {
            eq = true;
            for (int i = 0; eq && i < arr1.length; ++i) {
                if (arr1[i] == arr2[i]) continue;
                eq = false;
            }
        }
        return eq;
    }
}

