/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupportConversionException;

public class FloatTypeSupport
extends TypeSupport<Float> {
    @Override
    public Float convert(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        if (value instanceof Short) {
            return Float.valueOf(((Short)value).floatValue());
        }
        if (value instanceof Integer) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        if (value instanceof Byte) {
            return Float.valueOf(((Byte)value).floatValue());
        }
        if (value instanceof Long) {
            return Float.valueOf(((Long)value).floatValue());
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw new TypeSupportConversionException(Errors.API_10, value.getClass().getSimpleName(), value);
    }
}

