/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.Field;
import com.streamsets.pipeline.api.FieldBatch;
import com.streamsets.pipeline.api.Record;
import java.util.Iterator;

public class RecordBasedFieldBatch
implements FieldBatch {
    private Record record;
    private Iterator<String> fieldPathIterator;
    private String currentFieldPath;
    private String fieldName;

    public RecordBasedFieldBatch(Record record) {
        this(record, record.getEscapedFieldPaths().iterator());
    }

    public RecordBasedFieldBatch(Record record, Iterator<String> fieldPaths) {
        this.record = record;
        this.fieldPathIterator = fieldPaths;
        this.currentFieldPath = null;
    }

    @Override
    public boolean hasNext() {
        return this.fieldPathIterator.hasNext();
    }

    @Override
    public boolean next() {
        if (!this.fieldPathIterator.hasNext()) {
            return false;
        }
        this.currentFieldPath = this.fieldPathIterator.next();
        this.fieldName = null;
        return true;
    }

    @Override
    public String getFieldPath() {
        return this.currentFieldPath;
    }

    @Override
    public String getFieldName() {
        if (this.fieldName != null) {
            return this.fieldName;
        }
        if (this.currentFieldPath == null) {
            return null;
        }
        String[] parts = this.currentFieldPath.split("/");
        this.fieldName = parts[parts.length - 1].replaceAll("\\[\\d+\\]$", "");
        return this.fieldName;
    }

    @Override
    public Field getField() {
        if (this.currentFieldPath != null) {
            return this.record.get(this.currentFieldPath);
        }
        return null;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public void replace(Field replacement) {
        if (this.currentFieldPath != null) {
            this.record.set(this.currentFieldPath, replacement);
        }
    }

    @Override
    public void drop() {
        if (this.currentFieldPath != null) {
            this.record.delete(this.currentFieldPath);
        }
    }
}

