/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api;

import com.streamsets.pipeline.api.StageDef;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExplorerSchema {
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+");
    private final Set root;
    private final java.util.Set<String> elementNames;
    private final Map<String, List<String>> parents;

    private ExplorerSchema() {
        this.root = null;
        this.elementNames = Collections.emptySet();
        this.parents = Collections.emptyMap();
    }

    protected ExplorerSchema(Element element, Element ... elements) {
        Utils.checkNotNull(element, "element");
        this.root = new Set(true, "", "", element, elements);
        this.visit(this.root, rec$ -> ((Element)rec$).setAddedToSchema());
        ArrayList names = new ArrayList();
        this.visit(this.root, e -> names.addAll(this.getSchemaElementNames((Element)e)));
        java.util.Set dupNames = names.stream().filter(name -> Collections.frequency(names, name) > 1).collect(Collectors.toSet());
        if (!dupNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("ExplorerSchema '%s' has duplicate elements: '%s'", this.getClass().getSimpleName(), dupNames));
        }
        this.elementNames = Collections.unmodifiableSet(new HashSet(names));
        this.parents = this.elementNames.stream().collect(Collectors.toMap(name -> name, name -> {
            ArrayList<String> list = new ArrayList<String>();
            ExplorerSchema.findParents(this.getRoot().getElements(), name, list);
            return Collections.unmodifiableList(list);
        }));
    }

    private void visit(Element element, Consumer<Element> visitor) {
        visitor.accept(element);
        element.asSet().ifPresent(set -> set.getElements().forEach(e -> this.visit((Element)e, visitor)));
    }

    private List<String> getSchemaElementNames(Element element) {
        return element.getName().isEmpty() ? Collections.emptyList() : Stream.concat(Stream.of(element.getName()), element.getAdditionalNamesIcons().keySet().stream()).collect(Collectors.toList());
    }

    private static boolean findParents(List<Element> schemaElements, String name, List<String> parents) {
        boolean found = false;
        for (Element schemaElement : schemaElements) {
            if ((found |= schemaElement.getName().equals(name)) || !(schemaElement instanceof Set) || !ExplorerSchema.findParents(((Set)schemaElement).getElements(), name, parents)) continue;
            parents.add(0, schemaElement.getName());
            return true;
        }
        return found;
    }

    public Set getRoot() {
        return this.root;
    }

    public java.util.Set<String> getElementNames() {
        return this.elementNames;
    }

    public List<String> getParents(String elementName) {
        return this.parents.get(Utils.checkNotNull(elementName, "elementName"));
    }

    private Element findElement(Element element, String name) {
        if (element.getName().equals(name)) {
            return element;
        }
        if (element.asSet().isPresent()) {
            for (Element child : element.asSet().get().getElements()) {
                element = this.findElement(child, name);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    private java.util.Set<String> getChildrenName(Element element, int upToChildDepth) {
        if (upToChildDepth == 0 || element.asAtom().isPresent()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        element.asSet().get().getElements().forEach(e -> {
            names.add(e.getName());
            names.addAll(this.getChildrenName((Element)e, upToChildDepth - 1));
        });
        return names;
    }

    public java.util.Set<String> getChildrenNames(String name, int upToChildDepth) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(upToChildDepth >= 0, "upToChildDepth must be >= 0");
        Element element = this.findElement(this.getRoot(), name);
        if (element == null) {
            throw new IllegalArgumentException(Utils.format("ExplorerSchema '{}' element '{}' does not exist", this.getClass().getSimpleName(), name));
        }
        return this.getChildrenName(element, upToChildDepth);
    }

    public String toString() {
        return "ExplorerSchema{root=" + this.root + '}';
    }

    public static ExplorerSchema getSchema(Class stageClass) {
        StageDef sDef = stageClass.getAnnotation(StageDef.class);
        try {
            return sDef.explorerSchema().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(Utils.format("Could not instantiate ExplorerSchema for StageDefinition '{}': {}", stageClass.getSimpleName(), ex.toString()), ex);
        }
    }

    public static class Set
    extends Element {
        private final List<Element> elements;

        public Set(String name, Element element, Element ... elements) {
            this(name, "", element, elements);
        }

        public Set(String name, String icon, Element element, Element ... elements) {
            this(false, name, icon, element, elements);
        }

        private Set(boolean root, String name, String icon, Element element, Element ... elements) {
            super(root, name, Utils.checkNotNull(icon, "icon"));
            Utils.checkNotNull(element, "element");
            ArrayList<Element> list = new ArrayList<Element>();
            list.add(element);
            list.addAll(Arrays.asList(elements));
            this.elements = Collections.unmodifiableList(list);
        }

        public List<Element> getElements() {
            return this.elements;
        }

        public String toString() {
            return "Set{names='" + this.getName() + '\'' + ", icons='" + this.getIcon() + "', elements ='" + this.elements + '\'' + '}';
        }
    }

    public static abstract class Element {
        private final String name;
        private final String icon;
        private Map<String, String> additionalNamesIcons;
        private boolean addedToSchema;

        protected Element(boolean root, String name, String icon) {
            this.name = root ? name : this.checkName(name);
            this.icon = icon;
            this.additionalNamesIcons = new HashMap<String, String>();
        }

        private void setAddedToSchema() {
            this.addedToSchema = true;
        }

        public Element also(String name) {
            return this.also(name, "");
        }

        private String checkName(String name) {
            Utils.checkArgument(WORD_PATTERN.matcher(name).matches(), Utils.format("ExplorerSchema '{}' invalid schema element name '{}', must be a word", this.getClass().getSimpleName(), name));
            return name;
        }

        public Element also(String name, String icon) {
            Utils.checkState(!this.addedToSchema, String.format("%s already added to a schema", this));
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(icon, "");
            this.additionalNamesIcons = new HashMap<String, String>(this.additionalNamesIcons);
            this.additionalNamesIcons.put(this.checkName(name), icon);
            this.additionalNamesIcons = Collections.unmodifiableMap(this.additionalNamesIcons);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public Map<String, String> getAdditionalNamesIcons() {
            return this.additionalNamesIcons;
        }

        public Optional<Atom> asAtom() {
            return Optional.ofNullable(this instanceof Atom ? (Atom)this : null);
        }

        public Optional<Set> asSet() {
            return Optional.ofNullable(this instanceof Set ? (Set)this : null);
        }
    }

    public static class Atom
    extends Element {
        public Atom(String name) {
            this(name, "");
        }

        public Atom(String name, String icon) {
            super(false, name, Utils.checkNotNull(icon, "icon"));
        }

        public String toString() {
            return "Atom{name='" + this.getName() + '\'' + ", icon='" + this.getIcon() + '\'' + '}';
        }
    }

    public static final class NONE
    extends ExplorerSchema {
    }
}

