/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api;

import com.streamsets.pipeline.api.ExplorerData;
import com.streamsets.pipeline.api.Stage;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface ExplorerSearcher<T> {
    default public List<Stage.ConfigIssue> initSearcher(Stage.Info info, Stage.Context context) {
        return Collections.emptyList();
    }

    public Tree search(ExplorerData<T> var1, SearchRequest var2);

    default public void destroySearcher() {
    }

    public static interface SearchRequest {
        public String getSchemaElement();

        public Map<String, String> getFixedSchemaElements();

        public String getSearch();

        public int getExtraDepth();

        public boolean isUpTruncate();

        public int getOffset();

        public int getLen();
    }

    public static class Tree {
        private final String name;
        private final String type;
        private Map<String, Tree> children;

        public static Tree root() {
            return new Tree();
        }

        private Tree() {
            this.name = null;
            this.type = null;
        }

        public Tree(String name, String type) {
            this.name = Utils.checkNotNull(name, "value");
            this.type = Utils.checkNotNull(type, "type");
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Tree addChild(Tree tree) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, Tree>();
            }
            this.children.put(tree.getName(), tree);
            return this;
        }

        public Tree getChild(String value) {
            return this.children == null ? null : this.children.get(value);
        }

        public Collection<Tree> getChildren() {
            return this.children == null ? null : this.children.values();
        }

        public String toString() {
            return "Tree{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", children=" + this.children + '}';
        }
    }
}

