/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api;

import com.streamsets.pipeline.api.FileRef;
import com.streamsets.pipeline.api.impl.BooleanTypeSupport;
import com.streamsets.pipeline.api.impl.ByteArrayTypeSupport;
import com.streamsets.pipeline.api.impl.ByteTypeSupport;
import com.streamsets.pipeline.api.impl.CharTypeSupport;
import com.streamsets.pipeline.api.impl.CreateByRef;
import com.streamsets.pipeline.api.impl.DateTypeSupport;
import com.streamsets.pipeline.api.impl.DecimalTypeSupport;
import com.streamsets.pipeline.api.impl.DoubleTypeSupport;
import com.streamsets.pipeline.api.impl.FileRefTypeSupport;
import com.streamsets.pipeline.api.impl.FloatTypeSupport;
import com.streamsets.pipeline.api.impl.IntegerTypeSupport;
import com.streamsets.pipeline.api.impl.ListMapTypeSupport;
import com.streamsets.pipeline.api.impl.ListTypeSupport;
import com.streamsets.pipeline.api.impl.LongTypeSupport;
import com.streamsets.pipeline.api.impl.MapTypeSupport;
import com.streamsets.pipeline.api.impl.ShortTypeSupport;
import com.streamsets.pipeline.api.impl.StringTypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.Utils;
import com.streamsets.pipeline.api.impl.ZonedDateTimeTypeSupport;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Field
implements Cloneable {
    private Type type;
    private Object value;
    private Map<String, String> attributes;

    private Field() {
    }

    private Field(Type type, Object value) {
        this(type, value, null);
    }

    private Field(Type type, Object value, Map<String, String> attributes) {
        this.type = type;
        Object object = this.value = CreateByRef.isByRef() ? value : type.constructorCopy(value);
        if (attributes != null) {
            this.attributes = new LinkedHashMap<String, String>(attributes);
        }
    }

    @Deprecated
    public static <T> Field create(Field field, T value) {
        return Field.create(Utils.checkNotNull(field, "field").getType(), value);
    }

    public static Field create(boolean v) {
        return new Field(Type.BOOLEAN, v);
    }

    public static Field create(char v) {
        return new Field(Type.CHAR, Character.valueOf(v));
    }

    public static Field create(byte v) {
        return new Field(Type.BYTE, v);
    }

    public static Field create(short v) {
        return new Field(Type.SHORT, v);
    }

    public static Field create(int v) {
        return new Field(Type.INTEGER, v);
    }

    public static Field create(long v) {
        return new Field(Type.LONG, v);
    }

    public static Field create(float v) {
        return new Field(Type.FLOAT, Float.valueOf(v));
    }

    public static Field create(double v) {
        return new Field(Type.DOUBLE, v);
    }

    public static Field create(BigDecimal v) {
        return new Field(Type.DECIMAL, v);
    }

    public static Field create(String v) {
        return new Field(Type.STRING, v);
    }

    public static Field create(byte[] v) {
        return new Field(Type.BYTE_ARRAY, v);
    }

    public static Field createDate(Date v) {
        return new Field(Type.DATE, v);
    }

    public static Field createDatetime(Date v) {
        return new Field(Type.DATETIME, v);
    }

    public static Field createTime(Date v) {
        return new Field(Type.TIME, v);
    }

    public static Field createZonedDateTime(ZonedDateTime v) {
        return new Field(Type.ZONED_DATETIME, v);
    }

    public static Field create(Map<String, Field> v) {
        return new Field(Type.MAP, v);
    }

    public static Field create(List<Field> v) {
        return new Field(Type.LIST, v);
    }

    public static Field createListMap(LinkedHashMap<String, Field> v) {
        return new Field(Type.LIST_MAP, v);
    }

    public static Field create(FileRef v) {
        return new Field(Type.FILE_REF, v);
    }

    public static <T> Field create(Type type, T value) {
        return Field.create(type, value, null);
    }

    public static <T> Field create(Type type, T value, Map<String, String> attributes) {
        return new Field(Utils.checkNotNull(type, "type"), type.convert(value), attributes);
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.type.getReference(this.value);
    }

    public boolean getValueAsBoolean() {
        return (Boolean)this.type.convert(this.getValue(), Type.BOOLEAN);
    }

    public char getValueAsChar() {
        return ((Character)this.type.convert(this.getValue(), Type.CHAR)).charValue();
    }

    public byte getValueAsByte() {
        return (Byte)this.type.convert(this.getValue(), Type.BYTE);
    }

    public short getValueAsShort() {
        return (Short)this.type.convert(this.getValue(), Type.SHORT);
    }

    public int getValueAsInteger() {
        return (Integer)this.type.convert(this.getValue(), Type.INTEGER);
    }

    public long getValueAsLong() {
        return (Long)this.type.convert(this.getValue(), Type.LONG);
    }

    public float getValueAsFloat() {
        return ((Float)this.type.convert(this.getValue(), Type.FLOAT)).floatValue();
    }

    public double getValueAsDouble() {
        return (Double)this.type.convert(this.getValue(), Type.DOUBLE);
    }

    public Date getValueAsDate() {
        return (Date)this.type.convert(this.getValue(), Type.DATE);
    }

    public Date getValueAsDatetime() {
        return (Date)this.type.convert(this.getValue(), Type.DATE);
    }

    public Date getValueAsTime() {
        return (Date)this.type.convert(this.getValue(), Type.TIME);
    }

    public ZonedDateTime getValueAsZonedDateTime() {
        return (ZonedDateTime)this.type.convert(this.getValue(), Type.ZONED_DATETIME);
    }

    public BigDecimal getValueAsDecimal() {
        return (BigDecimal)this.type.convert(this.getValue(), Type.DECIMAL);
    }

    public String getValueAsString() {
        return (String)this.type.convert(this.getValue(), Type.STRING);
    }

    public byte[] getValueAsByteArray() {
        return (byte[])this.type.convert(this.getValue(), Type.BYTE_ARRAY);
    }

    public Map<String, Field> getValueAsMap() {
        return (Map)this.type.convert(this.getValue(), Type.MAP);
    }

    public List<Field> getValueAsList() {
        return (List)this.type.convert(this.getValue(), Type.LIST);
    }

    public LinkedHashMap<String, Field> getValueAsListMap() {
        return (LinkedHashMap)this.type.convert(this.getValue(), Type.LIST_MAP);
    }

    public FileRef getValueAsFileRef() {
        return (FileRef)this.type.convert(this.getValue(), Type.FILE_REF);
    }

    public Set<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public void setAttributes(Map<String, String> attributes) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(attributes);
        } else {
            this.attributes.putAll(attributes);
        }
    }

    public void deleteAttribute(String name) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(name);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public String toString() {
        return this.type.toString(this.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj != null && obj instanceof Field) {
            Field other = (Field)obj;
            if (this.type == other.type) {
                boolean bl = eq = this.value == other.value || this.type.equals(this.value, other.value);
            }
            eq = this.attributes == null ? (eq &= other.attributes == null) : (eq &= this.attributes.equals(other.attributes));
        }
        return eq;
    }

    public Field clone() {
        return new Field(this.type, this.value, this.attributes);
    }

    public static enum Type {
        BOOLEAN(new BooleanTypeSupport()),
        CHAR(new CharTypeSupport()),
        BYTE(new ByteTypeSupport()),
        SHORT(new ShortTypeSupport()),
        INTEGER(new IntegerTypeSupport()),
        LONG(new LongTypeSupport()),
        FLOAT(new FloatTypeSupport()),
        DOUBLE(new DoubleTypeSupport()),
        DATE(new DateTypeSupport()),
        DATETIME(new DateTypeSupport()),
        TIME(new DateTypeSupport()),
        DECIMAL(new DecimalTypeSupport()),
        STRING(new StringTypeSupport()),
        FILE_REF(new FileRefTypeSupport()),
        BYTE_ARRAY(new ByteArrayTypeSupport()),
        MAP(new MapTypeSupport()),
        LIST(new ListTypeSupport()),
        LIST_MAP(new ListMapTypeSupport()),
        ZONED_DATETIME(new ZonedDateTimeTypeSupport());

        final transient TypeSupport<?> supporter;

        private Type(TypeSupport<?> supporter) {
            this.supporter = supporter;
        }

        private Object convert(Object value) {
            return value != null ? this.supporter.convert(value) : null;
        }

        private Object convert(Object value, Type targetType) {
            return value != null ? this.supporter.convert(value, targetType.supporter) : null;
        }

        private boolean equals(Object value1, Object value2) {
            return this.supporter.equals(value1, value2);
        }

        private <T> T constructorCopy(T value) {
            return (T)(value != null ? this.supporter.create(value) : null);
        }

        private <T> T getReference(T value) {
            return (T)(value != null ? this.supporter.get(value) : null);
        }

        private String toString(Object value) {
            return Utils.format("Field[{}:{}]", new Object[]{this, this.supporter.getClass().equals(ZonedDateTimeTypeSupport.class) ? Utils.format((ZonedDateTime)value) : value});
        }

        public boolean isOneOf(Type ... types) {
            if (types == null) {
                return false;
            }
            for (Type t : types) {
                if (this != t) continue;
                return true;
            }
            return false;
        }
    }
}

