/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.base;

import com.streamsets.pipeline.api.Batch;
import com.streamsets.pipeline.api.BatchMaker;
import com.streamsets.pipeline.api.ErrorCode;
import com.streamsets.pipeline.api.Processor;
import com.streamsets.pipeline.api.Record;
import com.streamsets.pipeline.api.Stage;
import com.streamsets.pipeline.api.StageException;
import com.streamsets.pipeline.api.base.BaseProcessor;
import com.streamsets.pipeline.api.base.Errors;
import java.util.List;

public abstract class SingleLaneProcessor
extends BaseProcessor {
    private String outputLane;

    public SingleLaneProcessor() {
        this.setRequiresSuperInit();
    }

    @Override
    protected List<Stage.ConfigIssue> init() {
        List<Stage.ConfigIssue> issues = super.init();
        if (((Processor.Context)this.getContext()).getOutputLanes().size() != 1) {
            issues.add(((Processor.Context)this.getContext()).createConfigIssue(null, null, (ErrorCode)Errors.API_00, this.getInfo().getInstanceName(), 1, ((Processor.Context)this.getContext()).getOutputLanes().size()));
        } else {
            this.outputLane = ((Processor.Context)this.getContext()).getOutputLanes().iterator().next();
        }
        this.setSuperInitCalled();
        return issues;
    }

    @Override
    public void process(Batch batch, final BatchMaker batchMaker) throws StageException {
        SingleLaneBatchMaker slBatchMaker = new SingleLaneBatchMaker(){

            @Override
            public void addRecord(Record record) {
                batchMaker.addRecord(record, SingleLaneProcessor.this.outputLane);
            }
        };
        this.process(batch, slBatchMaker);
    }

    public abstract void process(Batch var1, SingleLaneBatchMaker var2) throws StageException;

    public static interface SingleLaneBatchMaker {
        public void addRecord(Record var1);
    }
}

