/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.ext.json.delegate;

import com.streamsets.pipeline.api.ext.json.JsonDelegate;
import com.streamsets.pipeline.api.ext.json.JsonRule;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;

public class LocalDateTimeDelegate
implements JsonDelegate<LocalDateTime> {
    private final JsonRule annotation;

    public LocalDateTimeDelegate(JsonRule annotation) {
        this.annotation = annotation;
    }

    @Override
    public JsonRule annotation() {
        return this.annotation;
    }

    @Override
    public String serialize(LocalDateTime value, Map<String, Object> options) {
        return String.valueOf(value.atZone(this.getZoneId(options)).toEpochSecond());
    }

    @Override
    public LocalDateTime deserialize(String value, Map<String, Object> options) {
        return value == null ? null : LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(value)), this.getZoneId(options));
    }

    private final ZoneId getZoneId(Map<String, Object> options) {
        Object zoneId = this.findOption(options, "zoneId");
        return zoneId == null ? ZoneId.systemDefault() : (ZoneId)zoneId;
    }

    public static interface Parameters {
        public static final String ZONE_ID = "zoneId";
    }
}

