/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.Field;
import com.streamsets.pipeline.api.base.Errors;
import com.streamsets.pipeline.api.impl.ListMapTypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupport;
import com.streamsets.pipeline.api.impl.TypeSupportConversionException;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ListTypeSupport
extends TypeSupport<List> {
    @Override
    public List convert(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        throw new TypeSupportConversionException(Errors.API_12, value.getClass().getSimpleName(), value);
    }

    @Override
    public Object convert(Object value, TypeSupport targetTypeSupport) {
        if (targetTypeSupport instanceof ListTypeSupport) {
            return value;
        }
        if (targetTypeSupport instanceof ListMapTypeSupport) {
            List list = (List)value;
            LinkedHashMap<String, Field> listMap = new LinkedHashMap<String, Field>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                listMap.put(Integer.toString(i), (Field)list.get(i));
            }
            return listMap;
        }
        throw new TypeSupportConversionException(Errors.API_13, targetTypeSupport);
    }

    @Override
    public Object clone(Object value) {
        List<Field> list = null;
        if (value != null) {
            list = ListTypeSupport.deepCopy((List)value);
        }
        return list;
    }

    private static List<Field> deepCopy(List<Field> list) {
        ArrayList<Field> copy = new ArrayList<Field>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Field field = list.get(i);
            Utils.checkNotNull(field, Utils.formatL("List has null element at '{}' pos", i));
            copy.add(field.clone());
        }
        return copy;
    }

    @Override
    public Object create(Object value) {
        return this.clone(value);
    }
}

