/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.impl;

import com.streamsets.pipeline.api.ErrorCode;
import com.streamsets.pipeline.api.impl.LocaleInContext;
import com.streamsets.pipeline.api.impl.LocalizableString;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizableMessage
implements LocalizableString {
    private static final Logger LOG = LoggerFactory.getLogger(LocalizableMessage.class);
    private static final Object[] NULL_ONE_ARG = new Object[]{null};
    private static final Set<String> MISSING_BUNDLE_WARNS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> MISSING_KEY_WARNS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ClassLoader classLoader;
    private final String bundle;
    private final String errorCode;
    private final String humanReadableMessage;
    private String technicalMessage = "";
    private String remediationSteps = "";
    private final Object[] args;

    public LocalizableMessage(ClassLoader classLoader, String bundle, String id, String defaultTemplate, Object[] args) {
        this.classLoader = Utils.checkNotNull(classLoader, "classLoader");
        this.bundle = bundle;
        this.errorCode = id;
        this.humanReadableMessage = defaultTemplate;
        this.args = args != null ? args : NULL_ONE_ARG;
    }

    public LocalizableMessage(ClassLoader classLoader, String bundle, ErrorCode errorCode, Object[] args) {
        this.classLoader = Utils.checkNotNull(classLoader, "classLoader");
        this.bundle = bundle;
        this.errorCode = errorCode.getCode();
        this.humanReadableMessage = errorCode.getMessage();
        this.technicalMessage = errorCode.getTechnicalMessage();
        this.remediationSteps = errorCode.getRemediationSteps();
        this.args = args != null ? args : NULL_ONE_ARG;
    }

    public LocalizableMessage(String bundle, String id, String defaultTemplate, Object[] args) {
        this(Thread.currentThread().getContextClassLoader(), bundle, id, defaultTemplate, args);
    }

    @Override
    public String getNonLocalized() {
        return Utils.format(this.humanReadableMessage, this.args);
    }

    @Override
    public String getLocalized() {
        String templateToUse;
        block6: {
            Locale locale;
            templateToUse = this.humanReadableMessage;
            if (this.bundle != null && (locale = LocaleInContext.get()) != null) {
                try {
                    ResourceBundle rb = ResourceBundle.getBundle(this.bundle, locale, this.classLoader);
                    if (rb.containsKey(this.errorCode)) {
                        templateToUse = rb.getString(this.errorCode);
                    } else if (!MISSING_KEY_WARNS.contains(this.bundle + " " + this.errorCode)) {
                        MISSING_KEY_WARNS.add(this.bundle + " " + this.errorCode);
                        LOG.warn("ResourceBundle '{}' does not have key '{}' via ClassLoader '{}'", new Object[]{this.bundle, this.errorCode, this.classLoader});
                    }
                }
                catch (MissingResourceException ex) {
                    if (MISSING_BUNDLE_WARNS.contains(this.bundle)) break block6;
                    MISSING_BUNDLE_WARNS.add(this.bundle);
                    LOG.trace("ResourceBundle '{}' not found via ClassLoader '{}'", (Object)this.bundle, (Object)this.classLoader);
                }
            }
        }
        return Utils.format(templateToUse, this.args);
    }

    @Override
    public String getHumanReadableMessage() {
        return Utils.format(this.humanReadableMessage, this.args);
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getTechnicalMessage() {
        return Utils.format(this.technicalMessage, this.args);
    }

    @Override
    public String getRemediationSteps() {
        return Utils.format(this.remediationSteps, this.args);
    }

    public String toString() {
        return this.getNonLocalized();
    }
}

