/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.service.sshtunnel;

import com.streamsets.pipeline.api.StageException;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface SshTunnelService {
    public boolean isEnabled();

    public Map<HostPort, HostPort> start(List<HostPort> var1);

    public void healthCheck() throws StageException;

    public void stop();

    public static class HostPort {
        private final String host;
        private final int port;

        public HostPort(String host, int port) {
            this.host = Utils.checkNotNull(host, "host");
            Utils.checkArgument(port > 0 && port <= 65535, Utils.formatL("Host '{}', port '{}' out of range", host, port));
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostPort that = (HostPort)o;
            return this.port == that.port && this.host.equals(that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }

        public String toString() {
            return "HostPortPair{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

