/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.systemexplorer.api;

import com.streamsets.pipeline.api.ConfigIssue;
import com.streamsets.systemexplorer.api.ExplorerData;
import com.streamsets.systemexplorer.api.ExplorerDataBoundaries;
import com.streamsets.systemexplorer.api.ExplorerRequestContext;
import java.util.Collections;
import java.util.List;

public interface ExplorerLoader<T, C> {
    public ExplorerData<T> getEmptyData();

    default public List<ConfigIssue> init(ExplorerRequestContext<C> explorerRequestContext) {
        return Collections.emptyList();
    }

    public void load(ExplorerData<T> var1, ExplorerDataBoundaries var2) throws InterruptedException, ExplorerLoaderException;

    default public void destroy() {
    }

    public static class ExplorerLoaderException
    extends Exception {
        public ExplorerLoaderException() {
        }

        public ExplorerLoaderException(String message) {
            super(message);
        }

        public ExplorerLoaderException(String message, Throwable cause) {
            super(message, cause);
        }

        public ExplorerLoaderException(Throwable cause) {
            super(cause);
        }

        public ExplorerLoaderException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }

    public static final class NoOp
    implements ExplorerLoader<Object, Void> {
        private static final ExplorerData<Object> NONE = new ExplorerData<Object>(new Object());
        public static final NoOp NOOP = new NoOp();

        private NoOp() {
        }

        @Override
        public ExplorerData<Object> getEmptyData() {
            return NONE;
        }

        @Override
        public void load(ExplorerData<Object> explorerData, ExplorerDataBoundaries explorerDataBoundaries) {
        }
    }
}

