/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.Logger;
import com.streamxhub.streamx.common.util.Logger$class;
import com.streamxhub.streamx.common.util.Utils$;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Supplier;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class ClassLoaderUtils$
implements Logger {
    public static final ClassLoaderUtils$ MODULE$;
    private final ClassLoader originalClassLoader;
    private transient org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger;
    private final String com$streamxhub$streamx$common$util$Logger$$prefix;

    static {
        new ClassLoaderUtils$();
    }

    @Override
    public org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger() {
        return this.com$streamxhub$streamx$common$util$Logger$$_logger;
    }

    @Override
    public void com$streamxhub$streamx$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String com$streamxhub$streamx$common$util$Logger$$prefix() {
        return this.com$streamxhub$streamx$common$util$Logger$$prefix;
    }

    @Override
    public void com$streamxhub$streamx$common$util$Logger$_setter_$com$streamxhub$streamx$common$util$Logger$$prefix_$eq(String x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public <R> R runAsClassLoader(ClassLoader targetClassLoader, Function0<R> func) {
        try {
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            return (R)func.apply();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }

    public <R> R runAsClassLoader(ClassLoader targetClassLoader, Supplier<R> supplier) {
        try {
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            return supplier.get();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }

    public void loadJar(String jarFilePath) {
        File jarFile = new File(jarFilePath);
        Predef$.MODULE$.require(jarFile.exists(), (Function0)new Serializable(jarFilePath){
            public static final long serialVersionUID = 0L;
            private final String jarFilePath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] ClassLoaderUtils.loadJar: jarFilePath ", " is not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jarFilePath$1}));
            }
            {
                this.jarFilePath$1 = jarFilePath$1;
            }
        });
        Predef$.MODULE$.require(jarFile.isFile(), (Function0)new Serializable(jarFilePath){
            public static final long serialVersionUID = 0L;
            private final String jarFilePath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] ClassLoaderUtils.loadJar: jarFilePath ", " is not file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jarFilePath$1}));
            }
            {
                this.jarFilePath$1 = jarFilePath$1;
            }
        });
        this.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loadPath(jarFile.getAbsolutePath(), this.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loadPath$default$2());
    }

    public void loadJars(String path) {
        File jarDir = new File(path);
        Predef$.MODULE$.require(jarDir.exists(), (Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] ClassLoaderUtils.loadJars: jarPath ", " is not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        Predef$.MODULE$.require(jarDir.isDirectory(), (Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] ClassLoaderUtils.loadJars: jarPath ", " is not directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        Predef$.MODULE$.require(jarDir.listFiles().length > 0, (Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] ClassLoaderUtils.loadJars: have not jar in path:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])jarDir.listFiles()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(File x) {
                ClassLoaderUtils$.MODULE$.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loadPath(x.getAbsolutePath(), ClassLoaderUtils$.MODULE$.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loadPath$default$2());
            }
        });
    }

    public void loadResource(String filepath) {
        File file = new File(filepath);
        this.addURL(file);
    }

    public void loadResourceDir(String filepath) {
        File file = new File(filepath);
        this.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loopDirs(file);
    }

    public void com$streamxhub$streamx$common$util$ClassLoaderUtils$$loadPath(String filepath, List<String> ext) {
        File file = new File(filepath);
        this.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loopFiles(file, ext);
    }

    public List<String> com$streamxhub$streamx$common$util$ClassLoaderUtils$$loadPath$default$2() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".jar", ".zip"}));
    }

    public void com$streamxhub$streamx$common$util$ClassLoaderUtils$$loopDirs(File file) {
        if (file.isDirectory()) {
            this.addURL(file);
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(File file) {
                    ClassLoaderUtils$.MODULE$.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loopDirs(file);
                }
            });
        }
    }

    public void com$streamxhub$streamx$common$util$ClassLoaderUtils$$loopFiles(File file, List<String> ext) {
        if (file.isDirectory()) {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(ext){
                public static final long serialVersionUID = 0L;
                private final List ext$1;

                public final void apply(File x) {
                    ClassLoaderUtils$.MODULE$.com$streamxhub$streamx$common$util$ClassLoaderUtils$$loopFiles(x, (List<String>)this.ext$1);
                }
                {
                    this.ext$1 = ext$1;
                }
            });
        } else if (ext.isEmpty()) {
            this.addURL(file);
        } else if (ext.exists((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final boolean apply(String x) {
                return this.file$1.getName().endsWith(x);
            }
            {
                this.file$1 = file$1;
            }
        })) {
            Utils$.MODULE$.checkJarFile(file.toURI().toURL());
            this.addURL(file);
        }
    }

    private List<String> loopFiles$default$2() {
        return Nil$.MODULE$;
    }

    private void addURL(File file) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader2 instanceof URLClassLoader) {
            Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", (Class[])((Object[])new Class[]{URL.class}));
            addURL.setAccessible(true);
            addURL.invoke((Object)classLoader2, file.toURI().toURL());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Field field = classLoader.getClass().getDeclaredField("ucp");
            field.setAccessible(true);
            Object ucp = field.get(classLoader);
            Method addURL = ucp.getClass().getDeclaredMethod("addURL", (Class[])((Object[])new Class[]{URL.class}));
            addURL.setAccessible(true);
            addURL.invoke(ucp, file.toURI().toURL());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return;
    }

    private ClassLoaderUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }
}

