/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.google.common.collect.Maps;
import com.streamxhub.streamx.common.fs.LfsOperator$;
import com.streamxhub.streamx.common.util.FileUtils$;
import com.streamxhub.streamx.common.util.HostsUtils$;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.ListMap;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;
import scala.util.Try$;

public final class HadoopConfigUtils$ {
    public static final HadoopConfigUtils$ MODULE$;
    private final String[] HADOOP_CLIENT_CONF_FILES;
    private final String[] HIVE_CLIENT_CONF_FILES;

    static {
        new HadoopConfigUtils$();
    }

    public String[] HADOOP_CLIENT_CONF_FILES() {
        return this.HADOOP_CLIENT_CONF_FILES;
    }

    public String[] HIVE_CLIENT_CONF_FILES() {
        return this.HIVE_CLIENT_CONF_FILES;
    }

    public Option<String> getSystemHadoopConfDir() {
        return Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return FileUtils$.MODULE$.getPathFromEnv("HADOOP_CONF_DIR");
            }
        }).recover((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = FileUtils$.MODULE$.resolvePath(FileUtils$.MODULE$.getPathFromEnv("HADOOP_HOME"), "/etc/hadoop");
                return (B1)string;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }).toOption();
    }

    public Optional<String> getSystemHadoopConfDirAsJava() {
        return Optional.ofNullable(this.getSystemHadoopConfDir().orNull(Predef$.MODULE$.$conforms()));
    }

    public Option<String> getSystemHiveConfDir() {
        return Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return FileUtils$.MODULE$.getPathFromEnv("HIVE_CONF_DIR");
            }
        }).toOption();
    }

    public Optional<String> getSystemHiveConfDirAsJava() {
        return Optional.ofNullable(this.getSystemHiveConfDir().orNull(Predef$.MODULE$.$conforms()));
    }

    public void replaceHostWithIP(File configFile) {
        ListMap<String, String> hostsMap;
        if (configFile.exists() && configFile.isFile() && configFile.getName().endsWith(".xml") && (hostsMap = HostsUtils$.MODULE$.getSortSystemHosts()).nonEmpty()) {
            this.com$streamxhub$streamx$common$util$HadoopConfigUtils$$rewriteHostIpMapper(configFile, hostsMap);
        }
    }

    public void batchReplaceHostWithIP(File configDir, String[] filter) {
        if (configDir.isDirectory()) {
            ListMap<String, String> hostsMap = HostsUtils$.MODULE$.getSortSystemHosts();
            if (hostsMap.isEmpty()) {
                return;
            }
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configDir.listFiles()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$1) {
                    return x$1.isFile();
                }
            })).filter((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                private final String[] filter$1;

                public final boolean apply(File e) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.filter$1).contains((Object)e.getName());
                }
                {
                    this.filter$1 = filter$1;
                }
            })).foreach((Function1)new Serializable(hostsMap){
                public static final long serialVersionUID = 0L;
                private final ListMap hostsMap$2;

                public final void apply(File x$2) {
                    HadoopConfigUtils$.MODULE$.com$streamxhub$streamx$common$util$HadoopConfigUtils$$rewriteHostIpMapper(x$2, (ListMap<String, String>)this.hostsMap$2);
                }
                {
                    this.hostsMap$2 = hostsMap$2;
                }
            });
            return;
        }
        this.replaceHostWithIP(configDir);
    }

    public String[] batchReplaceHostWithIP$default$2() {
        return this.HADOOP_CLIENT_CONF_FILES();
    }

    public void com$streamxhub$streamx$common$util$HadoopConfigUtils$$rewriteHostIpMapper(File configFile, ListMap<String, String> hostsMap) {
        Buffer lines = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(FileUtils.readLines((File)configFile)).map((Function1)new Serializable(hostsMap){
            public static final long serialVersionUID = 0L;
            private final ListMap hostsMap$1;

            public final String apply(String x0$1) {
                String string;
                String string2 = x0$1;
                if (string2.trim().startsWith("<value>")) {
                    Option shot = this.hostsMap$1.find((Function1)new Serializable(this, string2){
                        public static final long serialVersionUID = 0L;
                        private final String x1$1;

                        public final boolean apply(Tuple2<String, String> e) {
                            return this.x1$1.contains((CharSequence)e._1());
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                    ObjectRef li = ObjectRef.create((Object)string2);
                    while (shot.nonEmpty()) {
                        li.elem = ((String)li.elem).replace((CharSequence)((Tuple2)shot.get())._1(), (CharSequence)((Tuple2)shot.get())._2());
                        shot = this.hostsMap$1.find((Function1)new Serializable(this, li){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef li$1;

                            public final boolean apply(Tuple2<String, String> e) {
                                return ((String)this.li$1.elem).contains((CharSequence)e._1());
                            }
                            {
                                this.li$1 = li$1;
                            }
                        });
                    }
                    string = (String)li.elem;
                } else {
                    string = string2;
                }
                return string;
            }
            {
                this.hostsMap$1 = hostsMap$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        FileUtils.writeLines((File)configFile, (Collection)JavaConversions$.MODULE$.bufferAsJavaList(lines));
    }

    public java.util.Map<String, String> readSystemHadoopConf() {
        return (java.util.Map)this.getSystemHadoopConfDir().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, String> apply(String confDir) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])LfsOperator$.MODULE$.listDir(confDir)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File f) {
                        return Predef$.MODULE$.refArrayOps((Object[])HadoopConfigUtils$.MODULE$.HADOOP_CLIENT_CONF_FILES()).contains((Object)f.getName());
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(File f) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)FileUtils.readFileToString((File)f, (String)"UTF-8"));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).asJava();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HashMap<String, String> apply() {
                return Maps.newHashMap();
            }
        });
    }

    public java.util.Map<String, String> readSystemHiveConf() {
        return (java.util.Map)this.getSystemHiveConfDir().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, String> apply(String confDir) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])LfsOperator$.MODULE$.listDir(confDir)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File f) {
                        return Predef$.MODULE$.refArrayOps((Object[])HadoopConfigUtils$.MODULE$.HIVE_CLIENT_CONF_FILES()).contains((Object)f.getName());
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(File f) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)FileUtils.readFileToString((File)f, (String)"UTF-8"));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).asJava();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HashMap<String, String> apply() {
                return Maps.newHashMap();
            }
        });
    }

    private HadoopConfigUtils$() {
        MODULE$ = this;
        this.HADOOP_CLIENT_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "yarn-site.xml"});
        this.HIVE_CLIENT_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "hive-site.xml"});
    }
}

