/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.RedisConfig$;
import com.streamxhub.streamx.common.util.RedisEndpoint;
import com.streamxhub.streamx.common.util.RedisEndpoint$;
import com.streamxhub.streamx.common.util.RedisNode;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\tY!+\u001a3jg\u000e{gNZ5h\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\u0019\u0019w.\\7p]*\u0011q\u0001C\u0001\bgR\u0014X-Y7y\u0015\tI!\"\u0001\u0006tiJ,\u0017-\u001c=ik\nT\u0011aC\u0001\u0004G>l7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t1\u0001\u0011)\u0019!C\u00013\u0005Y\u0011N\\5uS\u0006d\u0007j\\:u+\u0005Q\u0002CA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u00055\u0011V\rZ5t\u000b:$\u0007o\\5oi\"Aq\u0004\u0001B\u0001B\u0003%!$\u0001\u0007j]&$\u0018.\u00197I_N$\b\u0005C\u0003\"\u0001\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0011\u0002\"a\u0007\u0001\t\u000ba\u0001\u0003\u0019\u0001\u000e\t\u000f\u0019\u0002!\u0019!C\u0001O\u0005Y\u0011N\\5uS\u0006d\u0017\t\u001a3s+\u0005A\u0003CA\u0015-\u001d\ty!&\u0003\u0002,!\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003\u0003\u0003\u00041\u0001\u0001\u0006I\u0001K\u0001\rS:LG/[1m\u0003\u0012$'\u000f\t\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003\u0015Awn\u001d;t+\u0005!\u0004cA\b6o%\u0011a\u0007\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037aJ!!\u000f\u0002\u0003\u0013I+G-[:O_\u0012,\u0007BB\u001e\u0001A\u0003%A'\u0001\u0004i_N$8\u000f\t\u0005\b{\u0001\u0011\r\u0011\"\u00014\u0003\u0015qw\u000eZ3t\u0011\u0019y\u0004\u0001)A\u0005i\u00051an\u001c3fg\u0002BQ!\u0011\u0001\u0005\u0002\u001d\nqaZ3u\u0003V$\b\u000eC\u0003D\u0001\u0011\u0005A)A\u0003hKR$%)F\u0001F!\tya)\u0003\u0002H!\t\u0019\u0011J\u001c;\t\u000b%\u0003A\u0011\u0001&\u0002\u001b\u001d,GOU1oI>lgj\u001c3f+\u00059\u0004\"\u0002'\u0001\t\u0003i\u0015aD4fi:{G-Z:CsNcw\u000e^:\u0015\u0007Qr\u0005\u000bC\u0003P\u0017\u0002\u0007Q)\u0001\u0003t!>\u001c\b\"B)L\u0001\u0004)\u0015\u0001B3Q_NDQa\u0015\u0001\u0005\u0002Q\u000b\u0001cY8o]\u0016\u001cG/[8o\r>\u00148*Z=\u0015\u0005U{\u0006C\u0001,^\u001b\u00059&B\u0001-Z\u0003\u0015QW\rZ5t\u0015\tQ6,A\u0004dY&,g\u000e^:\u000b\u0003q\u000bQA]3eSNL!AX,\u0003\u000b)+G-[:\t\u000b\u0001\u0014\u0006\u0019\u0001\u0015\u0002\u0007-,\u0017\u0010C\u0003c\u0001\u0011%1-\u0001\bdYV\u001cH/\u001a:F]\u0006\u0014G.\u001a3\u0015\u0005\u0011<\u0007CA\bf\u0013\t1\u0007CA\u0004C_>dW-\u00198\t\u000ba\t\u0007\u0019\u0001\u000e\t\u000b%\u0004A\u0011\u00016\u0002\u000f\u001d,G\u000fS8tiR\u0011qg\u001b\u0005\u0006A\"\u0004\r\u0001\u000b\u0005\u0006[\u0002!IA\\\u0001\tO\u0016$\bj\\:ugR\u0011Ag\u001c\u0005\u000611\u0004\rA\u0007\u0005\u0006c\u0002!IA]\u0001\u0013O\u0016$hj\u001c8DYV\u001cH/\u001a:O_\u0012,7\u000f\u0006\u00025g\")\u0001\u0004\u001da\u00015!)Q\u000f\u0001C\u0005m\u0006yq-\u001a;DYV\u001cH/\u001a:O_\u0012,7\u000f\u0006\u00025o\")\u0001\u0004\u001ea\u00015!)\u0011\u0010\u0001C\u0001u\u0006Aq-\u001a;O_\u0012,7\u000f\u0006\u00025w\")\u0001\u0004\u001fa\u00015\u0001")
public class RedisConfig
implements Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().db();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.nodes()).filter((Function1)new Serializable(this, sPos, ePos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisConfig $outer;
            private final int sPos$1;
            private final int ePos$1;

            public final boolean apply(RedisNode node) {
                return this.$outer.com$streamxhub$streamx$common$util$RedisConfig$$inter$1(this.sPos$1, this.ePos$1, node.startSlot(), node.endSlot());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sPos$1 = sPos$1;
                this.ePos$1 = ePos$1;
            }
        })).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$1) {
                return x$1.idx() == 0;
            }
        });
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version2 = ((String[])Predef$.MODULE$.refArrayOps((Object[])info).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains("redis_version:");
            }
        }))[0];
        String[] clusterEnable = (String[])Predef$.MODULE$.refArrayOps((Object[])info).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains("cluster_enabled:");
            }
        });
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version2.substring(14, version2.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return ((RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.hosts()).filter((Function1)new Serializable(this, slot){
            public static final long serialVersionUID = 0L;
            private final int slot$1;

            public final boolean apply(RedisNode host) {
                return host.startSlot() <= this.slot$1 && host.endSlot() >= this.slot$1;
            }
            {
                this.slot$1 = slot$1;
            }
        }))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$4) {
                return x$4.idx() == 0;
            }
        });
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!Predef$.MODULE$.refArrayOps((Object[])replinfo).exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$5) {
                    return x$5.contains("role:slave");
                }
            })) break;
            String host = ((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$6) {
                    return x$6.contains("master_host:");
                }
            }))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$7) {
                    return x$7.contains("master_port:");
                }
            }))[0].trim().substring(12))).toInt();
            initialHost = new RedisEndpoint(host, port, initialHost.auth(), initialHost.db(), RedisEndpoint$.MODULE$.apply$default$5());
        }
        Tuple2[] slaves = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x) {
                return x.contains("slave") && x.contains("online");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String rl) {
                String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
                String ip = content[0];
                String port = content[1];
                return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])slaves).$plus$colon((Object)tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range = nodes.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1)new Serializable(this, initialHost, nodes, range){
            public static final long serialVersionUID = 0L;
            private final RedisEndpoint initialHost$1;
            private final Tuple2[] nodes$1;
            private final int range$1;

            public final RedisNode apply(int i) {
                return new RedisNode(new RedisEndpoint((String)this.nodes$1[i]._1(), this.nodes$1[i]._2$mcI$sp(), this.initialHost$1.auth(), this.initialHost$1.db(), this.initialHost$1.timeout()), 0, 16383, i, this.range$1);
            }
            {
                this.initialHost$1 = initialHost$1;
                this.nodes$1 = nodes$1;
                this.range$1 = range$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(conn.clusterSlots()).flatMap((Function1)new Serializable(this, initialHost){
            public static final long serialVersionUID = 0L;
            public final RedisEndpoint initialHost$2;

            public final IndexedSeq<RedisNode> apply(Object slotInfoObj) {
                List slotInfo = (List)slotInfoObj;
                int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
                int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1)new Serializable(this, slotInfo, sPos, ePos){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final List slotInfo$1;
                    private final int sPos$2;
                    private final int ePos$2;

                    public final RedisNode apply(int i) {
                        List node = (List)JavaConversions$.MODULE$.asScalaBuffer(this.slotInfo$1).apply(i + 2);
                        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
                        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
                        return new RedisNode(new RedisEndpoint(host, port, this.$outer.initialHost$2.auth(), this.$outer.initialHost$2.db(), this.$outer.initialHost$2.timeout()), this.sPos$2, this.ePos$2, i, this.slotInfo$1.size() - 2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.slotInfo$1 = slotInfo$1;
                        this.sPos$2 = sPos$2;
                        this.ePos$2 = ePos$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.initialHost$2 = initialHost$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    public final boolean com$streamxhub$streamx$common$util$RedisConfig$$inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

