/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private String OS;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    private String OS$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.OS = System.getProperty("os.name").toLowerCase();
                this.bitmap$0 = true;
            }
            return this.OS;
        }
    }

    private String OS() {
        return this.bitmap$0 ? this.OS : this.OS$lzycompute();
    }

    public boolean notEmpty(Object elem) {
        Object object = elem;
        boolean bl = object == null ? false : (object instanceof CharSequence ? new StringOps(Predef$.MODULE$.augmentString(elem.toString().trim())).nonEmpty() : (object instanceof Traversable ? ((Traversable)object).nonEmpty() : (object instanceof Iterable ? ((Iterable)object).nonEmpty() : (object instanceof Collection ? !((Collection)object).isEmpty() : (object instanceof Map ? !((Map)object).isEmpty() : true)))));
        return bl;
    }

    public boolean isEmpty(Object elem) {
        return !this.notEmpty(elem);
    }

    public String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public void require(boolean requirement, String message) {
        if (requirement) {
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requirement failed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
    }

    public void checkJarFile(URL jar) throws IOException {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(jar){
            public static final long serialVersionUID = 0L;
            private final URL jar$1;

            public final File apply() {
                return new File(this.jar$1.toURI());
            }
            {
                this.jar$1 = jar$1;
            }
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            File x = (File)success.value();
            File file = x;
            File jarFile = file;
            if (jarFile.exists()) {
                if (jarFile.canRead()) {
                    Try try_2 = Try$.MODULE$.apply((Function0)new Serializable(jarFile){
                        public static final long serialVersionUID = 0L;
                        private final File jarFile$1;

                        public final JarFile apply() {
                            return new JarFile(this.jarFile$1);
                        }
                        {
                            this.jarFile$1 = jarFile$1;
                        }
                    });
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable e = failure.exception();
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while opening jar file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarFile.getAbsolutePath()})), e);
                    }
                    if (try_2 instanceof Success) {
                        Success success2 = (Success)try_2;
                        JarFile x2 = (JarFile)success2.value();
                        x2.close();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)try_2);
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAR file can't be read '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarFile.getAbsolutePath()})));
            }
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAR file does not exist '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarFile.getAbsolutePath()})));
        }
        if (try_ instanceof Failure) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAR file path is invalid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jar})));
        }
        throw new MatchError((Object)try_);
    }

    public Manifest getJarManifest(File jarFile) {
        this.checkJarFile(jarFile.toURL());
        return new JarInputStream(new BufferedInputStream(new FileInputStream(jarFile))).getManifest();
    }

    public void copyProperties(Properties original, Properties target) {
        JavaConversions$.MODULE$.propertiesAsScalaMap(original).foreach((Function1)new Serializable(target){
            public static final long serialVersionUID = 0L;
            private final Properties target$1;

            public final Object apply(Tuple2<String, String> x) {
                return this.target$1.put(x._1(), x._2());
            }
            {
                this.target$1 = target$1;
            }
        });
    }

    public String getOsName() {
        return this.OS();
    }

    public boolean isLinux() {
        return this.OS().indexOf("linux") >= 0;
    }

    public boolean isWindows() {
        return this.OS().indexOf("windows") >= 0;
    }

    public boolean isAnyBank(Seq<String> items) {
        return items == null || items.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CharSequence x$1) {
                return StringUtils.isBlank((CharSequence)x$1);
            }
        });
    }

    public <R, T extends AutoCloseable> R tryWithResource(T handle, Function1<T, R> func, Function1<Throwable, R> excFunc) {
        try {
            Throwable throwable2;
            block7: {
                Object object;
                try {
                    object = func.apply(handle);
                }
                catch (Throwable throwable2) {
                    Object object2;
                    Throwable throwable3 = throwable2;
                    if (throwable3 == null) break block7;
                    Throwable throwable4 = throwable3;
                    if (excFunc == null) break block7;
                    object = object2 = excFunc.apply((Object)throwable4);
                }
                return (R)object;
            }
            throw throwable2;
        }
        finally {
            if (handle != null) {
                handle.close();
            }
        }
    }

    public <R, T extends AutoCloseable> Null$ tryWithResource$default$3(T handle, Function1<T, R> func) {
        return null;
    }

    public void close(Seq<AutoCloseable> closeable, Function1<Throwable, BoxedUnit> func) {
        closeable.foreach((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final void apply(AutoCloseable c) {
                Throwable throwable2;
                block3: {
                    try {
                        if (c != null) {
                            c.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        if (throwable3 == null) break block3;
                        Throwable throwable4 = throwable3;
                        if (this.func$1 == null) break block3;
                        BoxedUnit boxedUnit = (BoxedUnit)this.func$1.apply((Object)throwable4);
                    }
                    return;
                }
                throw throwable2;
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public Function1<Throwable, BoxedUnit> close$default$2(Seq<AutoCloseable> closeable) {
        return null;
    }

    public double calPercent(long num1, long num2) {
        return num1 == 0L || num2 == 0L ? 0.0 : new StringOps(Predef$.MODULE$.augmentString(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)num1 / (double)num2 * (double)100))), "%.1f"))).toDouble();
    }

    private Utils$() {
        MODULE$ = this;
    }
}

