/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.HadoopUtils$;
import com.streamxhub.streamx.common.util.Logger;
import com.streamxhub.streamx.common.util.Logger$class;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HdfsUtils$
implements Logger {
    public static final HdfsUtils$ MODULE$;
    private transient org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger;
    private final String com$streamxhub$streamx$common$util$Logger$$prefix;

    static {
        new HdfsUtils$();
    }

    @Override
    public org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger() {
        return this.com$streamxhub$streamx$common$util$Logger$$_logger;
    }

    @Override
    public void com$streamxhub$streamx$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String com$streamxhub$streamx$common$util$Logger$$prefix() {
        return this.com$streamxhub$streamx$common$util$Logger$$prefix;
    }

    @Override
    public void com$streamxhub$streamx$common$util$Logger$_setter_$com$streamxhub$streamx$common$util$Logger$$prefix_$eq(String x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public String getDefaultFS() {
        return HadoopUtils$.MODULE$.hadoopConf().get("fs.defaultFS");
    }

    public List<FileStatus> list(String src) {
        return Predef$.MODULE$.refArrayOps((Object[])HadoopUtils$.MODULE$.hdfs().listStatus(this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(src))).toList();
    }

    public void move(String src, String dst) {
        HadoopUtils$.MODULE$.hdfs().rename(this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(src), this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(dst));
    }

    public void mkdirs(String path) {
        HadoopUtils$.MODULE$.hdfs().mkdirs(this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(path));
    }

    public void copyHdfs(String src, String dst, boolean delSrc, boolean overwrite) {
        Path srcPath = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(src);
        Path dstPath = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(dst);
        FileStatus dstStatus = HadoopUtils$.MODULE$.hdfs().getFileStatus(dstPath);
        Path dstFinalPath = dstStatus.isFile() ? dstPath : this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dst, srcPath.getName()})));
        FileUtil.copy((FileSystem)HadoopUtils$.MODULE$.hdfs(), (Path)srcPath, (FileSystem)HadoopUtils$.MODULE$.hdfs(), (Path)dstFinalPath, (boolean)delSrc, (boolean)overwrite, (Configuration)HadoopUtils$.MODULE$.hadoopConf());
    }

    public boolean copyHdfs$default$3() {
        return false;
    }

    public boolean copyHdfs$default$4() {
        return true;
    }

    public void copyHdfsDir(String src, String dst, boolean delSrc, boolean overwrite) {
        this.list(src).foreach((Function1)new Serializable(dst, delSrc, overwrite){
            public static final long serialVersionUID = 0L;
            private final String dst$1;
            private final boolean delSrc$1;
            private final boolean overwrite$1;

            public final boolean apply(FileStatus x) {
                return FileUtil.copy((FileSystem)HadoopUtils$.MODULE$.hdfs(), (FileStatus)x, (FileSystem)HadoopUtils$.MODULE$.hdfs(), (Path)HdfsUtils$.MODULE$.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(this.dst$1), (boolean)this.delSrc$1, (boolean)this.overwrite$1, (Configuration)HadoopUtils$.MODULE$.hadoopConf());
            }
            {
                this.dst$1 = dst$1;
                this.delSrc$1 = delSrc$1;
                this.overwrite$1 = overwrite$1;
            }
        });
    }

    public boolean copyHdfsDir$default$3() {
        return false;
    }

    public boolean copyHdfsDir$default$4() {
        return true;
    }

    public void upload(String src, String dst, boolean delSrc, boolean overwrite) {
        HadoopUtils$.MODULE$.hdfs().copyFromLocalFile(delSrc, overwrite, this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(src), this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(dst));
    }

    public boolean upload$default$3() {
        return false;
    }

    public boolean upload$default$4() {
        return true;
    }

    public void uploadMulti(String[] src, String dst, boolean delSrc, boolean overwrite) {
        HadoopUtils$.MODULE$.hdfs().copyFromLocalFile(delSrc, overwrite, (Path[])Predef$.MODULE$.refArrayOps((Object[])src).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(String hdfsPath) {
                return HdfsUtils$.MODULE$.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(hdfsPath);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))), this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(dst));
    }

    public boolean uploadMulti$default$3() {
        return false;
    }

    public boolean uploadMulti$default$4() {
        return true;
    }

    public void download(String src, String dst, boolean delSrc, boolean useRawLocalFileSystem) {
        HadoopUtils$.MODULE$.hdfs().copyToLocalFile(delSrc, this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(src), this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(dst), useRawLocalFileSystem);
    }

    public boolean download$default$3() {
        return false;
    }

    public boolean download$default$4() {
        return false;
    }

    public String getNameNode() {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HdfsUtils$.MODULE$.getAddressOfActive(HadoopUtils$.MODULE$.hdfs()).getHostString();
            }
        });
        if (try_ instanceof Success) {
            String value;
            Success success = (Success)try_;
            String string = value = (String)success.value();
            return string;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    public void create(String fileName, String content) {
        Path path = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(fileName);
        Predef$.MODULE$.require(HadoopUtils$.MODULE$.hdfs().exists(path), (Function0)new Serializable(fileName){
            public static final long serialVersionUID = 0L;
            private final String fileName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] HdfsUtils.create ", " is exists!! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileName$1}));
            }
            {
                this.fileName$1 = fileName$1;
            }
        });
        FSDataOutputStream outputStream = HadoopUtils$.MODULE$.hdfs().create(path);
        outputStream.writeUTF(content);
        outputStream.flush();
        outputStream.close();
    }

    public boolean exists(String path) {
        return HadoopUtils$.MODULE$.hdfs().exists(this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(path));
    }

    public String read(String fileName) {
        Path path = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(fileName);
        Predef$.MODULE$.require(HadoopUtils$.MODULE$.hdfs().exists(path) && !HadoopUtils$.MODULE$.hdfs().isDirectory(path), (Function0)new Serializable(fileName){
            public static final long serialVersionUID = 0L;
            private final String fileName$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamX] HdfsUtils.read: path(", ") not exists or isDirectory "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileName$2}));
            }
            {
                this.fileName$2 = fileName$2;
            }
        });
        FSDataInputStream in = HadoopUtils$.MODULE$.hdfs().open(path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096, (boolean)false);
        out.flush();
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        return new String(out.toByteArray());
    }

    public void delete(String src) {
        Path path = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(src);
        if (HadoopUtils$.MODULE$.hdfs().exists(path)) {
            HadoopUtils$.MODULE$.hdfs().delete(path, true);
        } else {
            this.logWarn((Function0<String>)new Serializable(src){
                public static final long serialVersionUID = 0L;
                private final String src$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs delete ", ",but file ", " is not exists!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.src$1, this.src$1}));
                }
                {
                    this.src$1 = src$1;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public String fileMd5(String fileName) {
        Path path = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(fileName);
        FSDataInputStream in = HadoopUtils$.MODULE$.hdfs().open(path);
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final FSDataInputStream in$1;

            public final String apply() {
                return DigestUtils.md5Hex((InputStream)this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String s = (String)success.value();
            in.close();
            String string = s;
            return string;
        }
        if (try_ instanceof Failure) {
            void var3_3;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            var3_3.close();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public void downToLocal(String hdfsPath, String localPath) {
        Path path = this.com$streamxhub$streamx$common$util$HdfsUtils$$getPath(hdfsPath);
        FSDataInputStream input2 = HadoopUtils$.MODULE$.hdfs().open(path);
        String content = input2.readUTF();
        FileWriter fw = new FileWriter(localPath);
        fw.write(content);
        fw.close();
        input2.close();
    }

    public Path com$streamxhub$streamx$common$util$HdfsUtils$$getPath(String hdfsPath) {
        return new Path(hdfsPath);
    }

    public InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (fs instanceof DistributedFileSystem) {
            fs.exists(new Path("/"));
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            DFSClient dfsClient = dfs.getClient();
            return RPC.getServerAddress((Object)dfsClient.getNamenode());
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileSystem ", " is not a DFS."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fs})));
    }

    private HdfsUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

