/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.utils;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.networking.QueryStringFactory;
import com.stripe.android.financialconnections.ElementsSessionContext;
import com.stripe.android.financialconnections.launcher.FinancialConnectionsSheetActivityArgs;
import com.stripe.android.financialconnections.utils.BillingDetailsExtensionsKt;
import com.stripe.android.model.IncentiveEligibilitySession;
import com.stripe.android.model.LinkMode;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJD\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/financialconnections/utils/HostedAuthUrlBuilder;", "", "<init>", "()V", "create", "", "args", "Lcom/stripe/android/financialconnections/launcher/FinancialConnectionsSheetActivityArgs;", "hostedAuthUrl", "prefillDetails", "Lcom/stripe/android/financialconnections/ElementsSessionContext$PrefillDetails;", "isInstantDebits", "", "linkMode", "Lcom/stripe/android/model/LinkMode;", "billingDetails", "Lcom/stripe/android/financialconnections/ElementsSessionContext$BillingDetails;", "incentiveEligibilitySession", "Lcom/stripe/android/model/IncentiveEligibilitySession;", "makeBillingDetailsQueryParams", "billingAddress", "financial-connections-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nHostedAuthUrlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostedAuthUrlBuilder.kt\ncom/stripe/android/financialconnections/utils/HostedAuthUrlBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class HostedAuthUrlBuilder {
    @NotNull
    public static final HostedAuthUrlBuilder INSTANCE = new HostedAuthUrlBuilder();

    private HostedAuthUrlBuilder() {
    }

    @Nullable
    public final String create(@NotNull FinancialConnectionsSheetActivityArgs args, @Nullable String hostedAuthUrl, @Nullable ElementsSessionContext.PrefillDetails prefillDetails) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ElementsSessionContext elementsSessionContext = args.getElementsSessionContext();
        ElementsSessionContext elementsSessionContext2 = args.getElementsSessionContext();
        ElementsSessionContext elementsSessionContext3 = args.getElementsSessionContext();
        return this.create(hostedAuthUrl, args instanceof FinancialConnectionsSheetActivityArgs.ForInstantDebits, (LinkMode)(elementsSessionContext != null ? elementsSessionContext.getLinkMode() : null), elementsSessionContext2 != null ? elementsSessionContext2.getBillingDetails() : null, prefillDetails, (IncentiveEligibilitySession)(elementsSessionContext3 != null ? elementsSessionContext3.getIncentiveEligibilitySession() : null));
    }

    public static /* synthetic */ String create$default(HostedAuthUrlBuilder hostedAuthUrlBuilder, FinancialConnectionsSheetActivityArgs financialConnectionsSheetActivityArgs, String string, ElementsSessionContext.PrefillDetails prefillDetails, int n, Object object) {
        if ((n & 4) != 0) {
            ElementsSessionContext elementsSessionContext = financialConnectionsSheetActivityArgs.getElementsSessionContext();
            prefillDetails = elementsSessionContext != null ? elementsSessionContext.getPrefillDetails() : null;
        }
        return hostedAuthUrlBuilder.create(financialConnectionsSheetActivityArgs, string, prefillDetails);
    }

    private final String create(String hostedAuthUrl, boolean isInstantDebits, LinkMode linkMode, ElementsSessionContext.BillingDetails billingDetails, ElementsSessionContext.PrefillDetails prefillDetails, IncentiveEligibilitySession incentiveEligibilitySession) {
        if (hostedAuthUrl == null) {
            return null;
        }
        Object[] objectArray = new String[]{hostedAuthUrl};
        List queryParams = CollectionsKt.mutableListOf((Object[])objectArray);
        if (isInstantDebits) {
            Object it;
            queryParams.add("return_payment_method=true");
            queryParams.add("expand_payment_method=true");
            queryParams.add("instantDebitsIncentive=" + (incentiveEligibilitySession != null));
            LinkMode linkMode2 = linkMode;
            if (linkMode2 != null) {
                it = linkMode2;
                boolean bl = false;
                queryParams.add("link_mode=" + it.getValue());
            }
            ElementsSessionContext.BillingDetails billingDetails2 = billingDetails;
            if (billingDetails2 != null) {
                it = billingDetails2;
                boolean bl = false;
                queryParams.add(INSTANCE.makeBillingDetailsQueryParams((ElementsSessionContext.BillingDetails)it));
            }
            IncentiveEligibilitySession incentiveEligibilitySession2 = incentiveEligibilitySession;
            if (incentiveEligibilitySession2 != null) {
                it = incentiveEligibilitySession2;
                boolean bl = false;
                queryParams.add("incentiveEligibilitySession=" + it.getId());
            }
        }
        ElementsSessionContext.PrefillDetails prefillDetails2 = prefillDetails;
        if (prefillDetails2 != null) {
            String it;
            ElementsSessionContext.PrefillDetails $this$create_u24lambda_u246 = prefillDetails2;
            boolean bl = false;
            String string = $this$create_u24lambda_u246.getEmail();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                queryParams.add("email=" + it);
            }
            String string2 = $this$create_u24lambda_u246.getPhone();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                queryParams.add("linkMobilePhone=" + it);
            }
            String string3 = $this$create_u24lambda_u246.getPhoneCountryCode();
            if (string3 != null) {
                it = string3;
                boolean bl4 = false;
                queryParams.add("linkMobilePhoneCountry=" + it);
            }
        }
        queryParams.add("launched_by=android_sdk");
        return CollectionsKt.joinToString$default((Iterable)queryParams, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    private final String makeBillingDetailsQueryParams(ElementsSessionContext.BillingDetails billingAddress) {
        Map params = MapsKt.mapOf((Pair)TuplesKt.to((Object)"billingDetails", BillingDetailsExtensionsKt.toApiParams(billingAddress)));
        return QueryStringFactory.INSTANCE.createFromParamsWithEmptyValues(params);
    }
}

