/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.repository;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.exception.AuthenticationException;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.exception.PermissionException;
import com.stripe.android.core.exception.RateLimitException;
import com.stripe.android.core.model.parsers.StripeErrorJsonParser;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.RequestId;
import com.stripe.android.core.networking.ResponseJsonKt;
import com.stripe.android.core.networking.StripeNetworkClient;
import com.stripe.android.core.networking.StripeRequest;
import com.stripe.android.core.networking.StripeResponse;
import com.stripe.android.financialconnections.model.FinancialConnectionsAccountList;
import com.stripe.android.financialconnections.model.FinancialConnectionsSession;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import com.stripe.android.financialconnections.model.GetFinancialConnectionsAcccountsParams;
import com.stripe.android.financialconnections.repository.FinancialConnectionsApiRepository;
import com.stripe.android.financialconnections.repository.FinancialConnectionsRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B-\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ-\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0019\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u00060'j\u0002`(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u000b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcom/stripe/android/financialconnections/repository/FinancialConnectionsApiRepository;", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepository;", "publishableKey", "", "stripeAccountId", "stripeNetworkClient", "Lcom/stripe/android/core/networking/StripeNetworkClient;", "apiRequestFactory", "Lcom/stripe/android/core/networking/ApiRequest$Factory;", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/core/networking/StripeNetworkClient;Lcom/stripe/android/core/networking/ApiRequest$Factory;)V", "json", "Lkotlinx/serialization/json/Json;", "getJson$financial_connections_release$annotations", "()V", "getJson$financial_connections_release", "()Lkotlinx/serialization/json/Json;", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "executeRequest", "Response", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "responseSerializer", "Lkotlinx/serialization/KSerializer;", "(Lcom/stripe/android/core/networking/StripeRequest;Lkotlinx/serialization/KSerializer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateFinancialConnectionsSessionManifest", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest;", "clientSecret", "applicationId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFinancialConnectionsAccounts", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsAccountList;", "getFinancialConnectionsAcccountsParams", "Lcom/stripe/android/financialconnections/model/GetFinancialConnectionsAcccountsParams;", "(Lcom/stripe/android/financialconnections/model/GetFinancialConnectionsAcccountsParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFinancialConnectionsSession", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSession;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleApiError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "response", "Lcom/stripe/android/core/networking/StripeResponse;", "Companion", "financial-connections_release"})
public final class FinancialConnectionsApiRepository
implements FinancialConnectionsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeNetworkClient stripeNetworkClient;
    @NotNull
    private final ApiRequest.Factory apiRequestFactory;
    @NotNull
    private final Json json;
    @NotNull
    private final ApiRequest.Options options;
    @NotNull
    private static final String API_HOST = "https://api.stripe.com";
    @NotNull
    public static final String PARAMS_CLIENT_SECRET = "client_secret";
    @NotNull
    public static final String PARAMS_APPLICATION_ID = "application_id";
    @NotNull
    public static final String PARAMS_FULLSCREEN = "fullscreen";
    @NotNull
    public static final String PARAMS_HIDE_CLOSE_BUTTON = "hide_close_button";
    @NotNull
    public static final String listAccountsUrl = "https://api.stripe.com/v1/link_account_sessions/list_accounts";
    @NotNull
    public static final String sessionReceiptUrl = "https://api.stripe.com/v1/link_account_sessions/session_receipt";
    @NotNull
    public static final String generateHostedUrl = "https://api.stripe.com/v1/link_account_sessions/generate_hosted_url";

    @Inject
    public FinancialConnectionsApiRepository(@Named(value="publishableKey") @NotNull String publishableKey, @Named(value="stripeAccountId") @Nullable String stripeAccountId, @NotNull StripeNetworkClient stripeNetworkClient, @NotNull ApiRequest.Factory apiRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)stripeNetworkClient, (String)"stripeNetworkClient");
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        this.stripeNetworkClient = stripeNetworkClient;
        this.apiRequestFactory = apiRequestFactory;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        this.options = new ApiRequest.Options(publishableKey, stripeAccountId, null, 4, null);
    }

    @NotNull
    public final Json getJson$financial_connections_release() {
        return this.json;
    }

    @VisibleForTesting
    public static /* synthetic */ void getJson$financial_connections_release$annotations() {
    }

    @Override
    @Nullable
    public Object getFinancialConnectionsAccounts(@NotNull GetFinancialConnectionsAcccountsParams getFinancialConnectionsAcccountsParams, @NotNull Continuation<? super FinancialConnectionsAccountList> $completion) {
        ApiRequest financialConnectionsRequest = this.apiRequestFactory.createGet(listAccountsUrl, this.options, getFinancialConnectionsAcccountsParams.toParamMap());
        return this.executeRequest((StripeRequest)financialConnectionsRequest, FinancialConnectionsAccountList.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object getFinancialConnectionsSession(@NotNull String clientSecret, @NotNull Continuation<? super FinancialConnectionsSession> $completion) {
        ApiRequest financialConnectionsRequest = this.apiRequestFactory.createGet(sessionReceiptUrl, this.options, MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAMS_CLIENT_SECRET, (Object)clientSecret)));
        return this.executeRequest((StripeRequest)financialConnectionsRequest, FinancialConnectionsSession.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object generateFinancialConnectionsSessionManifest(@NotNull String clientSecret, @NotNull String applicationId, @NotNull Continuation<? super FinancialConnectionsSessionManifest> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PARAMS_FULLSCREEN, (Object)Boxing.boxBoolean((boolean)true)), TuplesKt.to((Object)PARAMS_HIDE_CLOSE_BUTTON, (Object)Boxing.boxBoolean((boolean)true)), TuplesKt.to((Object)PARAMS_CLIENT_SECRET, (Object)clientSecret), TuplesKt.to((Object)PARAMS_APPLICATION_ID, (Object)applicationId)};
        ApiRequest financialConnectionsRequest = this.apiRequestFactory.createPost(generateHostedUrl, this.options, MapsKt.mapOf((Pair[])pairArray));
        return this.executeRequest((StripeRequest)financialConnectionsRequest, FinancialConnectionsSessionManifest.Companion.serializer(), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final <Response> Object executeRequest(StripeRequest var1_1, KSerializer<Response> var2_2, Continuation<? super Response> var3_3) {
        if (!(var3_3 instanceof executeRequest.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ FinancialConnectionsApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FinancialConnectionsApiRepository.access$executeRequest(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this;
                $this$executeRequest_u24lambda_u2d0 = var4_7;
                $i$a$-runCatching-FinancialConnectionsApiRepository$executeRequest$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = responseSerializer;
                $continuation.label = 1;
                v0 = $this$executeRequest_u24lambda_u2d0.stripeNetworkClient.executeRequest(request, $continuation);
                ** if (v0 != var10_6) goto lbl25
lbl24:
                // 1 sources

                return var10_6;
lbl25:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                $i$a$-runCatching-FinancialConnectionsApiRepository$executeRequest$2 = false;
                responseSerializer = (KSerializer)$continuation.L$2;
                request = (StripeRequest)$continuation.L$1;
                this = (FinancialConnectionsApiRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl35:
                    // 2 sources

                    $this$executeRequest_u24lambda_u2d0 = Result.constructor-impl((Object)((StripeResponse)v0));
                }
                catch (Throwable $i$a$-runCatching-FinancialConnectionsApiRepository$executeRequest$2) {
                    $this$executeRequest_u24lambda_u2d0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-FinancialConnectionsApiRepository$executeRequest$2));
                }
                var4_7 = $this$executeRequest_u24lambda_u2d0;
                v1 = Result.exceptionOrNull-impl((Object)var4_7);
                if (v1 == null) {
                    response = (StripeResponse)var4_7;
                    $i$a$-fold-FinancialConnectionsApiRepository$executeRequest$3 = false;
                    if (response.isError()) {
                        throw this.handleApiError((StripeResponse<String>)response);
                    }
                    v2 = response.getBody();
                    if (v2 == null) {
                        var7_11 = "Required value was null.";
                        throw new IllegalArgumentException(var7_11.toString());
                    }
                } else {
                    it = v1;
                    $i$a$-fold-FinancialConnectionsApiRepository$executeRequest$4 = false;
                    throw new APIConnectionException("Failed to execute " + request, it);
                }
                return this.json.decodeFromString((DeserializationStrategy)responseSerializer, (String)v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Exception handleApiError(StripeResponse<String> response) throws InvalidRequestException, AuthenticationException, APIException {
        Throwable throwable;
        RequestId requestId = response.getRequestId();
        String requestId2 = requestId != null ? requestId.getValue() : null;
        int responseCode = response.getCode();
        StripeError stripeError = new StripeErrorJsonParser().parse(ResponseJsonKt.responseJson(response));
        switch (responseCode) {
            case 400: 
            case 404: {
                throwable = (Throwable)new InvalidRequestException(stripeError, requestId2, responseCode, null, null, 24, null);
                break;
            }
            case 401: {
                throwable = (Throwable)new AuthenticationException(stripeError, requestId2);
                break;
            }
            case 403: {
                throwable = (Throwable)new PermissionException(stripeError, requestId2);
                break;
            }
            case 429: {
                throwable = (Throwable)new RateLimitException(stripeError, requestId2, null, null, 12, null);
                break;
            }
            default: {
                throwable = (Throwable)new APIException(stripeError, requestId2, responseCode, null, null, 24, null);
            }
        }
        throw throwable;
    }

    public static final /* synthetic */ Object access$executeRequest(FinancialConnectionsApiRepository $this, StripeRequest request, KSerializer responseSerializer, Continuation $completion) {
        return $this.executeRequest(request, responseSerializer, $completion);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/financialconnections/repository/FinancialConnectionsApiRepository$Companion;", "", "()V", "API_HOST", "", "PARAMS_APPLICATION_ID", "PARAMS_CLIENT_SECRET", "PARAMS_FULLSCREEN", "PARAMS_HIDE_CLOSE_BUTTON", "generateHostedUrl", "listAccountsUrl", "sessionReceiptUrl", "financial-connections_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

