/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import com.stripe.android.financialconnections.FinancialConnectionsSheet;
import com.stripe.android.financialconnections.analytics.AnalyticsMappersKt;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsEventReporter;
import com.stripe.android.financialconnections.launcher.FinancialConnectionsSheetActivityResult;
import com.stripe.android.financialconnections.utils.CollectionsKt;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter;", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsEventReporter;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/core/networking/AnalyticsRequestFactory;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/core/networking/AnalyticsRequestFactory;Lkotlin/coroutines/CoroutineContext;)V", "fireEvent", "", "event", "Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event;", "onPresented", "configuration", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;", "onResult", "financialConnectionsSheetResult", "Lcom/stripe/android/financialconnections/launcher/FinancialConnectionsSheetActivityResult;", "Companion", "Event", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class DefaultFinancialConnectionsEventReporter
implements FinancialConnectionsEventReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final CoroutineContext workContext;
    public static final int $stable = 8;
    @NotNull
    public static final String PARAM_CLIENT_SECRET = "las_client_secret";
    @NotNull
    public static final String PARAM_SESSION_RESULT = "session_result";

    @Inject
    public DefaultFinancialConnectionsEventReporter(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @IOContext @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
        this.workContext = workContext;
    }

    @Override
    public void onPresented(@NotNull FinancialConnectionsSheet.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.fireEvent(new Event(Event.Code.SheetPresented, MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_CLIENT_SECRET, (Object)configuration.getFinancialConnectionsSessionClientSecret()))));
    }

    @Override
    public void onResult(@NotNull FinancialConnectionsSheet.Configuration configuration, @NotNull FinancialConnectionsSheetActivityResult financialConnectionsSheetResult) {
        Event event;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)financialConnectionsSheetResult, (String)"financialConnectionsSheetResult");
        FinancialConnectionsSheetActivityResult financialConnectionsSheetActivityResult = financialConnectionsSheetResult;
        if (financialConnectionsSheetActivityResult instanceof FinancialConnectionsSheetActivityResult.Completed) {
            pairArray = new Pair[]{TuplesKt.to((Object)PARAM_CLIENT_SECRET, (Object)configuration.getFinancialConnectionsSessionClientSecret()), TuplesKt.to((Object)PARAM_SESSION_RESULT, (Object)"completed")};
            Event event2 = new Event(Event.Code.SheetClosed, MapsKt.mapOf((Pair[])pairArray));
            event = event2;
        } else if (financialConnectionsSheetActivityResult instanceof FinancialConnectionsSheetActivityResult.Canceled) {
            pairArray = new Pair[]{TuplesKt.to((Object)PARAM_CLIENT_SECRET, (Object)configuration.getFinancialConnectionsSessionClientSecret()), TuplesKt.to((Object)PARAM_SESSION_RESULT, (Object)"cancelled")};
            Event event3 = new Event(Event.Code.SheetClosed, MapsKt.mapOf((Pair[])pairArray));
            event = event3;
        } else if (financialConnectionsSheetActivityResult instanceof FinancialConnectionsSheetActivityResult.Failed) {
            pairArray = new Pair[]{TuplesKt.to((Object)PARAM_CLIENT_SECRET, (Object)configuration.getFinancialConnectionsSessionClientSecret()), TuplesKt.to((Object)PARAM_SESSION_RESULT, (Object)"failure")};
            Event event4 = new Event(Event.Code.SheetFailed, MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), CollectionsKt.filterNotNullValues(AnalyticsMappersKt.toEventParams(((FinancialConnectionsSheetActivityResult.Failed)financialConnectionsSheetResult).getError(), null))));
            event = event4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Event event5 = event;
        this.fireEvent(event5);
    }

    private final void fireEvent(Event event) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ DefaultFinancialConnectionsEventReporter this$0;
            final /* synthetic */ Event $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultFinancialConnectionsEventReporter.access$getAnalyticsRequestExecutor$p(this.this$0).executeAsync(DefaultFinancialConnectionsEventReporter.access$getAnalyticsRequestFactory$p(this.this$0).createRequest((AnalyticsEvent)this.$event, this.$event.getAdditionalParams()));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ AnalyticsRequestExecutor access$getAnalyticsRequestExecutor$p(DefaultFinancialConnectionsEventReporter $this) {
        return $this.analyticsRequestExecutor;
    }

    public static final /* synthetic */ AnalyticsRequestFactory access$getAnalyticsRequestFactory$p(DefaultFinancialConnectionsEventReporter $this) {
        return $this.analyticsRequestFactory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Companion;", "", "()V", "PARAM_CLIENT_SECRET", "", "PARAM_SESSION_RESULT", "financial-connections_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event;", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "eventCode", "Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event$Code;", "additionalParams", "", "", "(Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event$Code;Ljava/util/Map;)V", "getAdditionalParams", "()Ljava/util/Map;", "getEventCode", "()Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event$Code;", "eventName", "getEventName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Code", "financial-connections_release"})
    private static final class Event
    implements AnalyticsEvent {
        @NotNull
        private final Code eventCode;
        @NotNull
        private final Map<String, String> additionalParams;
        @NotNull
        private final String eventName;

        public Event(@NotNull Code eventCode, @NotNull Map<String, String> additionalParams) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventCode), (String)"eventCode");
            Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
            this.eventCode = eventCode;
            this.additionalParams = additionalParams;
            this.eventName = this.eventCode.toString();
        }

        public /* synthetic */ Event(Code code, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(code, map2);
        }

        @NotNull
        public final Code getEventCode() {
            return this.eventCode;
        }

        @NotNull
        public final Map<String, String> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @NotNull
        public final Code component1() {
            return this.eventCode;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.additionalParams;
        }

        @NotNull
        public final Event copy(@NotNull Code eventCode, @NotNull Map<String, String> additionalParams) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventCode), (String)"eventCode");
            Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
            return new Event(eventCode, additionalParams);
        }

        public static /* synthetic */ Event copy$default(Event event, Code code, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                code = event.eventCode;
            }
            if ((n & 2) != 0) {
                map2 = event.additionalParams;
            }
            return event.copy(code, map2);
        }

        @NotNull
        public String toString() {
            return "Event(eventCode=" + this.eventCode + ", additionalParams=" + this.additionalParams + ")";
        }

        public int hashCode() {
            int result = this.eventCode.hashCode();
            result = result * 31 + ((Object)this.additionalParams).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (this.eventCode != event.eventCode) {
                return false;
            }
            return Intrinsics.areEqual(this.additionalParams, event.additionalParams);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event$Code;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$financial_connections_release", "()Ljava/lang/String;", "toString", "SheetPresented", "SheetClosed", "SheetFailed", "Companion", "financial-connections_release"})
        public static final class Code
        extends Enum<Code> {
            @NotNull
            private static final Companion Companion;
            @NotNull
            private final String code;
            @NotNull
            private static final String PREFIX = "stripe_android.connections";
            public static final /* enum */ Code SheetPresented;
            public static final /* enum */ Code SheetClosed;
            public static final /* enum */ Code SheetFailed;
            private static final /* synthetic */ Code[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Code(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode$financial_connections_release() {
                return this.code;
            }

            @NotNull
            public String toString() {
                return "stripe_android.connections." + this.code;
            }

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            public static Code valueOf(String value) {
                return Enum.valueOf(Code.class, value);
            }

            @NotNull
            public static EnumEntries<Code> getEntries() {
                return $ENTRIES;
            }

            static {
                SheetPresented = new Code("sheet.presented");
                SheetClosed = new Code("sheet.closed");
                SheetFailed = new Code("sheet.failed");
                $VALUES = codeArray = new Code[]{Code.SheetPresented, Code.SheetClosed, Code.SheetFailed};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/financialconnections/analytics/DefaultFinancialConnectionsEventReporter$Event$Code$Companion;", "", "()V", "PREFIX", "", "financial-connections_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

