/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.di;

import android.app.Application;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.ApiVersion;
import com.stripe.android.financialconnections.FinancialConnectionsSheet;
import dagger.Module;
import dagger.Provides;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/financialconnections/di/FinancialConnectionsSheetConfigurationModule;", "", "()V", "providesApiVersion", "Lcom/stripe/android/core/ApiVersion;", "providesApplicationId", "", "application", "Landroid/app/Application;", "providesEnableLogging", "", "providesPublishableKey", "configuration", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;", "providesStripeAccountId", "financial-connections_release"})
@StabilityInferred(parameters=1)
public final class FinancialConnectionsSheetConfigurationModule {
    @NotNull
    public static final FinancialConnectionsSheetConfigurationModule INSTANCE = new FinancialConnectionsSheetConfigurationModule();
    public static final int $stable;

    private FinancialConnectionsSheetConfigurationModule() {
    }

    @Provides
    @Named(value="publishableKey")
    @Singleton
    @NotNull
    public final String providesPublishableKey(@NotNull FinancialConnectionsSheet.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration.getPublishableKey();
    }

    @Provides
    @Named(value="stripeAccountId")
    @Singleton
    @Nullable
    public final String providesStripeAccountId(@NotNull FinancialConnectionsSheet.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration.getStripeAccountId();
    }

    @Provides
    @Named(value="enableLogging")
    @Singleton
    public final boolean providesEnableLogging() {
        return false;
    }

    @Provides
    @Singleton
    @Named(value="applicationId")
    @NotNull
    public final String providesApplicationId(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        String string2 = application.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
        return string2;
    }

    @Provides
    @Singleton
    @NotNull
    public final ApiVersion providesApiVersion() {
        return new ApiVersion(SetsKt.setOf((Object)"financial_connections_client_api_beta=v1"));
    }
}

