/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.domain;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.financialconnections.FinancialConnectionsSheet;
import com.stripe.android.financialconnections.model.SynchronizeSessionResponse;
import com.stripe.android.financialconnections.repository.FinancialConnectionsManifestRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0086B\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync;", "", "repository", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;", "configuration", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;", "applicationId", "", "(Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;Ljava/lang/String;)V", "getConfiguration", "()Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;", "getRepository", "()Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;", "invoke", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "refetchCondition", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "(Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "RefetchCondition", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class GetOrFetchSync {
    @NotNull
    private final FinancialConnectionsManifestRepository repository;
    @NotNull
    private final FinancialConnectionsSheet.Configuration configuration;
    @NotNull
    private final String applicationId;
    public static final int $stable = 8;

    @Inject
    public GetOrFetchSync(@NotNull FinancialConnectionsManifestRepository repository, @NotNull FinancialConnectionsSheet.Configuration configuration, @Named(value="applicationId") @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.repository = repository;
        this.configuration = configuration;
        this.applicationId = applicationId;
    }

    @NotNull
    public final FinancialConnectionsManifestRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final FinancialConnectionsSheet.Configuration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public final Object invoke(@NotNull RefetchCondition refetchCondition, @NotNull Continuation<? super SynchronizeSessionResponse> $completion) {
        return this.repository.getOrSynchronizeFinancialConnectionsSession(this.configuration.getFinancialConnectionsSessionClientSecret(), this.applicationId, (Function1<? super SynchronizeSessionResponse, Boolean>)((Function1)new Function1<SynchronizeSessionResponse, Boolean>((Object)refetchCondition){

            @NotNull
            public final Boolean invoke(@NotNull SynchronizeSessionResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((RefetchCondition)this.receiver).shouldReFetch(p0);
            }
        }), $completion);
    }

    public static /* synthetic */ Object invoke$default(GetOrFetchSync getOrFetchSync, RefetchCondition refetchCondition, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            refetchCondition = RefetchCondition.None.INSTANCE;
        }
        return getOrFetchSync.invoke(refetchCondition, (Continuation<? super SynchronizeSessionResponse>)continuation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "", "shouldReFetch", "", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "Always", "IfMissingActiveAuthSession", "None", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$Always;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$IfMissingActiveAuthSession;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$None;", "financial-connections_release"})
    public static interface RefetchCondition {
        public boolean shouldReFetch(@NotNull SynchronizeSessionResponse var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\rH\u00d6\u0001\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$Always;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "()V", "equals", "", "other", "", "hashCode", "", "shouldReFetch", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "toString", "", "financial-connections_release"})
        @StabilityInferred(parameters=1)
        public static final class Always
        implements RefetchCondition {
            @NotNull
            public static final Always INSTANCE = new Always();
            public static final int $stable;

            private Always() {
            }

            @Override
            public boolean shouldReFetch(@NotNull SynchronizeSessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return true;
            }

            @NotNull
            public String toString() {
                return "Always";
            }

            public int hashCode() {
                return 1484658098;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Always)) {
                    return false;
                }
                Always cfr_ignored_0 = (Always)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\rH\u00d6\u0001\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$IfMissingActiveAuthSession;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "()V", "equals", "", "other", "", "hashCode", "", "shouldReFetch", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "toString", "", "financial-connections_release"})
        @StabilityInferred(parameters=1)
        public static final class IfMissingActiveAuthSession
        implements RefetchCondition {
            @NotNull
            public static final IfMissingActiveAuthSession INSTANCE = new IfMissingActiveAuthSession();
            public static final int $stable;

            private IfMissingActiveAuthSession() {
            }

            @Override
            public boolean shouldReFetch(@NotNull SynchronizeSessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return response.getManifest().getActiveAuthSession() == null;
            }

            @NotNull
            public String toString() {
                return "IfMissingActiveAuthSession";
            }

            public int hashCode() {
                return 1982328450;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IfMissingActiveAuthSession)) {
                    return false;
                }
                IfMissingActiveAuthSession cfr_ignored_0 = (IfMissingActiveAuthSession)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\rH\u00d6\u0001\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$None;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "()V", "equals", "", "other", "", "hashCode", "", "shouldReFetch", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "toString", "", "financial-connections_release"})
        @StabilityInferred(parameters=1)
        public static final class None
        implements RefetchCondition {
            @NotNull
            public static final None INSTANCE = new None();
            public static final int $stable;

            private None() {
            }

            @Override
            public boolean shouldReFetch(@NotNull SynchronizeSessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return false;
            }

            @NotNull
            public String toString() {
                return "None";
            }

            public int hashCode() {
                return -1660633189;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof None)) {
                    return false;
                }
                None cfr_ignored_0 = (None)other;
                return true;
            }
        }
    }
}

