/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.domain;

import com.stripe.android.core.exception.StripeException;
import com.stripe.android.financialconnections.exception.AccountLoadError;
import com.stripe.android.financialconnections.exception.AccountNoneEligibleForPaymentMethodError;
import com.stripe.android.financialconnections.model.FinancialConnectionsAuthorizationSession;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"toDomainException", "Lcom/stripe/android/core/exception/StripeException;", "institution", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsInstitution;", "businessName", "", "canRetry", "", "showManualEntry", "toPollIntervalMs", "", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsAuthorizationSession$Flow;", "financial-connections_release"})
public final class PollAuthorizationSessionAccountsKt {
    private static final StripeException toDomainException(StripeException $this$toDomainException, FinancialConnectionsInstitution institution, String businessName, boolean canRetry, boolean showManualEntry) {
        StripeException stripeException;
        if (institution == null) {
            stripeException = $this$toDomainException;
        } else {
            Object object = $this$toDomainException.getStripeError();
            if (Intrinsics.areEqual(object != null && (object = object.getExtraFields()) != null ? (String)object.get("reason") : null, (Object)"no_supported_payment_method_type_accounts_found")) {
                Object object2 = $this$toDomainException.getStripeError();
                int n = object2 != null && (object2 = object2.getExtraFields()) != null && (object2 = (String)object2.get("total_accounts_count")) != null ? Integer.parseInt((String)object2) : 0;
                String string2 = businessName;
                if (string2 == null) {
                    string2 = "";
                }
                stripeException = new AccountNoneEligibleForPaymentMethodError(n, institution, string2, $this$toDomainException);
            } else {
                stripeException = new AccountLoadError(showManualEntry, canRetry, institution, $this$toDomainException);
            }
        }
        return stripeException;
    }

    private static final long toPollIntervalMs(FinancialConnectionsAuthorizationSession.Flow $this$toPollIntervalMs) {
        long l;
        long defaultInitialPollDelay = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((double)1.75, (DurationUnit)DurationUnit.SECONDS));
        FinancialConnectionsAuthorizationSession.Flow flow = $this$toPollIntervalMs;
        switch (flow == null ? -1 : WhenMappings.$EnumSwitchMapping$0[flow.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                l = 0L;
                break;
            }
            case 5: {
                l = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((double)0.5, (DurationUnit)DurationUnit.SECONDS));
                break;
            }
            default: {
                l = defaultInitialPollDelay;
            }
        }
        return l;
    }

    public static final /* synthetic */ long access$toPollIntervalMs(FinancialConnectionsAuthorizationSession.Flow $receiver) {
        return PollAuthorizationSessionAccountsKt.toPollIntervalMs($receiver);
    }

    public static final /* synthetic */ StripeException access$toDomainException(StripeException $receiver, FinancialConnectionsInstitution institution, String businessName, boolean canRetry, boolean showManualEntry) {
        return PollAuthorizationSessionAccountsKt.toDomainException($receiver, institution, businessName, canRetry, showManualEntry);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FinancialConnectionsAuthorizationSession.Flow.values().length];
            try {
                nArray[FinancialConnectionsAuthorizationSession.Flow.TESTMODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinancialConnectionsAuthorizationSession.Flow.TESTMODE_OAUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinancialConnectionsAuthorizationSession.Flow.TESTMODE_OAUTH_WEBVIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinancialConnectionsAuthorizationSession.Flow.FINICITY_CONNECT_V2_LITE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinancialConnectionsAuthorizationSession.Flow.MX_CONNECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

