/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.domain;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.financialconnections.FinancialConnectionsSheet;
import com.stripe.android.financialconnections.domain.PostAuthorizationSession;
import com.stripe.android.financialconnections.exception.FinancialConnectionsError;
import com.stripe.android.financialconnections.exception.InstitutionPlannedDowntimeError;
import com.stripe.android.financialconnections.exception.InstitutionUnplannedDowntimeError;
import com.stripe.android.financialconnections.features.common.ManifestExtensionsKt;
import com.stripe.android.financialconnections.model.FinancialConnectionsAuthorizationSession;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import com.stripe.android.financialconnections.model.SynchronizeSessionResponse;
import com.stripe.android.financialconnections.repository.FinancialConnectionsManifestRepository;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086B\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/financialconnections/domain/PostAuthorizationSession;", "", "repository", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;", "configuration", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;", "applicationId", "", "(Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;Ljava/lang/String;)V", "getConfiguration", "()Lcom/stripe/android/financialconnections/FinancialConnectionsSheet$Configuration;", "getRepository", "()Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;", "invoke", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsAuthorizationSession;", "institution", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsInstitution;", "sync", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "(Lcom/stripe/android/financialconnections/model/FinancialConnectionsInstitution;Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toDomainException", "Lcom/stripe/android/core/exception/StripeException;", "showManualEntry", "", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class PostAuthorizationSession {
    @NotNull
    private final FinancialConnectionsManifestRepository repository;
    @NotNull
    private final FinancialConnectionsSheet.Configuration configuration;
    @NotNull
    private final String applicationId;
    public static final int $stable = 8;

    @Inject
    public PostAuthorizationSession(@NotNull FinancialConnectionsManifestRepository repository, @NotNull FinancialConnectionsSheet.Configuration configuration, @Named(value="applicationId") @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.repository = repository;
        this.configuration = configuration;
        this.applicationId = applicationId;
    }

    @NotNull
    public final FinancialConnectionsManifestRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final FinancialConnectionsSheet.Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object invoke(@NotNull FinancialConnectionsInstitution var1_1, @NotNull SynchronizeSessionResponse var2_2, @NotNull Continuation<? super FinancialConnectionsAuthorizationSession> var3_3) {
        if (!(var3_3 instanceof invoke.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ PostAuthorizationSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.invoke(null, null, (Continuation<? super FinancialConnectionsAuthorizationSession>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this.repository;
                var5_8 = this.configuration.getFinancialConnectionsSessionClientSecret();
                var6_10 = this.applicationId;
                $continuation.L$0 = this;
                $continuation.L$1 = institution;
                $continuation.L$2 = sync;
                $continuation.label = 1;
                v0 = var4_7.postAuthorizationSession(var5_8, var6_10, institution, (Continuation<? super FinancialConnectionsAuthorizationSession>)$continuation);
                ** if (v0 != var9_6) goto lbl24
lbl23:
                // 1 sources

                return var9_6;
lbl24:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                sync = (SynchronizeSessionResponse)$continuation.L$2;
                institution = (FinancialConnectionsInstitution)$continuation.L$1;
                this = (PostAuthorizationSession)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    var4_7 = (FinancialConnectionsAuthorizationSession)v0;
                }
                catch (StripeException e) {
                    throw this.toDomainException(e, ManifestExtensionsKt.showManualEntryInErrors(sync), institution);
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final StripeException toDomainException(StripeException $this$toDomainException, boolean showManualEntry, FinancialConnectionsInstitution institution) {
        Object object;
        block4: {
            block3: {
                CharSequence charSequence;
                String availableAt;
                object = $this$toDomainException.getStripeError();
                if (object == null) break block3;
                StripeError it = object;
                boolean bl = false;
                Map map2 = it.getExtraFields();
                String institutionUnavailable = map2 != null ? (String)map2.get("institution_unavailable") : null;
                Map map3 = it.getExtraFields();
                String string2 = availableAt = map3 != null ? (String)map3.get("expected_to_be_available_at") : null;
                StripeException stripeException = Intrinsics.areEqual((Object)institutionUnavailable, (Object)"true") ? (StripeException)((charSequence = (CharSequence)availableAt) == null || charSequence.length() == 0 ? (FinancialConnectionsError)new InstitutionUnplannedDowntimeError(institution, showManualEntry, $this$toDomainException) : (FinancialConnectionsError)new InstitutionPlannedDowntimeError(institution, showManualEntry, true, Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)Long.parseLong(availableAt), (DurationUnit)DurationUnit.SECONDS)), $this$toDomainException)) : $this$toDomainException;
                object = stripeException;
                if (stripeException != null) break block4;
            }
            object = $this$toDomainException;
        }
        return object;
    }
}

