/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.domain;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.Logger;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTracker;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTrackerKt;
import com.stripe.android.financialconnections.domain.HandleError;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import com.stripe.android.financialconnections.navigation.Destination;
import com.stripe.android.financialconnections.navigation.NavigationManager;
import com.stripe.android.financialconnections.repository.FinancialConnectionsErrorRepository;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/financialconnections/domain/RealHandleError;", "Lcom/stripe/android/financialconnections/domain/HandleError;", "errorRepository", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsErrorRepository;", "analyticsTracker", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;", "logger", "Lcom/stripe/android/core/Logger;", "navigationManager", "Lcom/stripe/android/financialconnections/navigation/NavigationManager;", "(Lcom/stripe/android/financialconnections/repository/FinancialConnectionsErrorRepository;Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;Lcom/stripe/android/core/Logger;Lcom/stripe/android/financialconnections/navigation/NavigationManager;)V", "invoke", "", "extraMessage", "", "error", "", "pane", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest$Pane;", "displayErrorScreen", "", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class RealHandleError
implements HandleError {
    @NotNull
    private final FinancialConnectionsErrorRepository errorRepository;
    @NotNull
    private final FinancialConnectionsAnalyticsTracker analyticsTracker;
    @NotNull
    private final Logger logger;
    @NotNull
    private final NavigationManager navigationManager;
    public static final int $stable = 8;

    @Inject
    public RealHandleError(@NotNull FinancialConnectionsErrorRepository errorRepository, @NotNull FinancialConnectionsAnalyticsTracker analyticsTracker, @NotNull Logger logger, @NotNull NavigationManager navigationManager) {
        Intrinsics.checkNotNullParameter((Object)errorRepository, (String)"errorRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsTracker, (String)"analyticsTracker");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
        this.errorRepository = errorRepository;
        this.analyticsTracker = analyticsTracker;
        this.logger = logger;
        this.navigationManager = navigationManager;
    }

    @Override
    public void invoke(@NotNull String extraMessage, @NotNull Throwable error, @NotNull FinancialConnectionsSessionManifest.Pane pane, boolean displayErrorScreen) {
        Intrinsics.checkNotNullParameter((Object)extraMessage, (String)"extraMessage");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)((Object)pane), (String)"pane");
        FinancialConnectionsAnalyticsTrackerKt.logError(this.analyticsTracker, extraMessage, error, this.logger, pane);
        if (displayErrorScreen) {
            this.errorRepository.set(error);
            NavigationManager.DefaultImpls.tryNavigateTo$default(this.navigationManager, Destination.invoke$default(Destination.Error.INSTANCE, pane, null, 2, null), null, false, 6, null);
        }
    }
}

